% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbr.R
\name{rcbr}
\alias{rcbr}
\title{Estimation of Random Coefficient Binary Response Models}
\usage{
rcbr(formula, data, subset, offset, mode = "GK", ...)
}
\arguments{
\item{formula}{an expression of the generic form \code{y ~ z + v} where
\code{y} is the observed binary response, \code{z} is an observed covariate
with a random coefficient, and \code{v} is an observed covariate with
coefficient normalize to be one.  If \code{z} is not present then the
model has only a random "intercept" coefficient  and thus corresponds
to the basic model of Cosslett (1983);  this model is also referred to
as the current status model in the biostatistics literature, see Groeneboom
and Hendrikx (2016).  When \code{z} is present there are random coefficients
associated with both the intercept and \code{z}.}

\item{data}{is a \code{data.frame} containing the data referenced in the
formula.}

\item{subset}{specifies a subsample of the data used for fitting the model}

\item{offset}{specifies a fixed shift in \code{v} representing the
potential effect of other covariates having fixed coefficients that may be
useful for profile likelihood computations.  (Should be vector of the same
length as \code{v}.}

\item{mode}{controls whether the Gautier and Kitamura, "GK", or Kiefer and
Wolfowitz, "KW" methods are used.}

\item{...}{miscellaneous other arguments to control fitting.
See \code{GK.control} and \code{KW.control} for further details.}
}
\value{
of object of class \code{GK}, \code{KW1}, with components described in 
further detail in the respective fitting functions.
}
\description{
Two methods are implemented for estimating binary response models  
with random coefficients:  A nonparametric maximum likelihood method
proposed by Cosslett (1986) and extended by Ichimura and Thompson (1998),
and a (hemispherical) deconvolution method proposed by Gautier and
and Kitamura (2013).  The former is closely related to the NPMLE
for mixture models of Kiefer and Wolfowitz (1956).  The latter is an
R translation of the matlab implementation of Gautier and Kitamura.
}
\details{
The \code{predict} method produces estimates of the probability of a "success"
(y = 1) for a particular vector, \code{(z,v)},  when aggregated over the estimated
distribution of random coefficients.

The \code{logLik} produces an evaluation of the log likelihood value
associated with a fitted model.
}
\references{
Kiefer, J. and J. Wolfowitz (1956) Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters, \emph{Ann. Math. Statist}, 27, 887-906.

Cosslett, S. (1983) Distribution Free Maximum Likelihood Estimator of the 
Binary Choice Model, \emph{Econometrica}, 51, 765-782.

Gautier, E. and Y. Kitamura (2013)  Nonparametric estimation in random coefficients
binary choice models, \emph{Ecoonmetrica}, 81, 581-607.

Groeneboom, P. and K. Hendrickx (2016) Current Status Linear Regression,
preprint available from \url{https://arxiv.org/abs/1601.00202}.

Ichimuma, H. and T. S. Thompson, (1998) Maximum likelihood estimation of a binary 
choice model with random coefficients of unknown distribution," 
\emph{Journal of Econometrics},  86, 269-295.
}
\author{
Jiaying Gu and Roger Koenker
}
\keyword{nonparametric}
