% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NICER.R
\name{NICER}
\alias{NICER}
\title{New Incremental Cell Enumeration (in) R}
\usage{
NICER(A, b, initial = c(0, 0), verb = TRUE, epsbound = 1,
  epstol = 1e-07)
}
\arguments{
\item{A}{is a n by 2 matrix of slope coefficients}

\item{b}{is an n vector of intercept coefficients}

\item{initial}{origin for the interior point vectors \code{w}}

\item{verb}{controls verbosity of Mosek solution}

\item{epsbound}{is a scalar tolerance controlling how close the witness point
can be to an edge of the polytope}

\item{epstol}{is a scalar tolerance for the LP convergence}
}
\value{
A list with components:
\itemize{
\item  SignVector a n by m matrix of signs determining position of cell relative 
	to each hyperplane.
\item  w a d by m matrix of interior points for the m cells
}
}
\description{
Find interior points and cell counts of the polygons (cells) formed by a
line arrangement.
}
\details{
Modified version of the algorithm of Rada and Cerny (2018).
The main modifications include preprocessing as hyperplanes are added
to determine which new cells are created, thereby reducing the number of
calls to the witness function to solve LPs, and treatment of degenerate
configurations as well as those in "general position."  When the hyperplanes
are in general position the number of polytopes (cells) is determined by the
elegant formula of Zazlavsky (1975) \deqn{m = {n \choose d} + n + 1}.  In
degenerate cases, i.e. when hyperplanes are not in general position, the
number of cells is more complicated as considered by Alexanderson and Wetzel (1981).
The function \code{polycount} is provided to check agreement with their results
in an effort to aid in the selection of tolerances for the \code{witness} function.
Current version is intended for use with \eqn{d = 2}, but the algorithm is adaptable to
\eqn{d > 2}, and there is an experimental version called \code{NICERd} in the package.
}
\references{
Alexanderson, G.L and J.E. Wetzel, (1981) Arrangements of planes in space, 
Discrete Math, 34, 219--240.
Rada, M. and M. Cerny (2018) A new algorithm for the enumeration of cells 
of hyperplane arrangements and a comparison with Avis and Fukada's reverse 
search, SIAM J. of Discrete Math, 32, 455-473.
Zaslavsky, T. (1975) Facing up to arrangements:  Face-Count Formulas for 
Partitions of Space by Hyperplanes, Memoirs of the AMS, Number 154.
}
