% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KWDual.R
\name{KWDual}
\alias{KWDual}
\title{Dual optimization for Kiefer-Wolfowitz problems}
\usage{
KWDual(A, d, w, ...)
}
\arguments{
\item{A}{Linear constraint matrix}

\item{d}{constraint vector}

\item{w}{weights for \code{x} should sum to one.}

\item{...}{other parameters passed to control optimization:  These may
include \code{rtol} the relative tolerance for dual gap convergence criterion,
\code{verb} to control verbosity desired from mosek, \code{verb = 0} is quiet,
\code{verb = 5} produces a fairly detailed iteration log,
\code{method} controls the choice of optimizer:  by default this is "mosek"
which employs interior point methods,}
}
\value{
Returns a list with components: 
\describe{
\item{f}{dual solution vector, the mixing density}
	\item{g}{primal solution vector, the mixture density
		evaluated at the data points} 
\item{logLik}{log likelihood}
\item{status}{return status from Mosek}
}
}
\description{
Optimization is carried out by Mosek and uses interior point methods.
It relies on the \pkg{Rmosek} interface to R see installation instructions at
\url{https://docs.mosek.com/8.1/rmosek/install-interface.html}.
}
\references{
Koenker, R and I. Mizera, (2013) ``Convex Optimization, Shape Constraints,
Compound Decisions, and Empirical Bayes Rules,'' \emph{JASA}, 109, 674--685.

Mosek Aps (2015) Users Guide to the R-to-Mosek Optimization Interface, 
\url{https://docs.mosek.com/8.1/rmosek/index.html}.  

Koenker, R. and J. Gu, (2017) REBayes: An {R} Package for Empirical Bayes Mixture Methods,
\emph{Journal of Statistical Software}, 82, 1--26.
}
\author{
R. Koenker
}
\keyword{nonparametrics}
