% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KW.control.R
\name{KW.control}
\alias{KW.control}
\title{Control parameters for NPMLE of bivariate random coefficient binary response}
\usage{
KW.control(uv = NULL, u = NULL, v = NULL, initial = c(0, 0),
  epsbound = 1, epstol = 1e-07, presolve = 1, verb = 0)
}
\arguments{
\item{uv}{matrix of evaluation points for potential mass points}

\item{u}{grid of evaluation points for potential mass points}

\item{v}{grid of evaluation points for potential mass points}

\item{initial}{initial point for cell enumeration algorithm}

\item{epsbound}{controls how close witness points can be to vertices of a cell}

\item{epstol}{zero tolerance for witness solutions}

\item{presolve}{controls whether Mosek does a presolve of the LP}

\item{verb}{controls verbosity of Mosek solver 0 implies it is quiet}
}
\value{
updated list
}
\description{
These parameters can be passed via the \code{...} argument of the \code{rcbr} function.
The first three arguments are only relevant if full cell enumeration is employed for
bivariate version of the NPMLE.
}
