# DGP location mixture of two Gaussians increment for KS
# This is considerably simplified from sim1.R since only KS is needed.
require(mvtnorm)
require(RCBR)
source("KleinSpady.R")
sessionInfo()

# true density from Gautier-Kitamura
n <- 500
B = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
Cov <- matrix(c(0.3,0.15,0,0.15,0.3,0,0,0,0),3,3)
u <- -40:40/20
v <- -40:40/20
du <- diff(u)[1]
dv <- diff(v)[1]
uv <- expand.grid(u,v)
w <- 0.5 * dmvnorm(uv, B[1,1:2], Cov[-3,-3]) + 0.5 * dmvnorm(uv, B[2,1:2], Cov[-3,-3])
w <- du * dv * w
fT <- list(u = u, v = v, uv = uv, W = w) # The truth
class(fT) <- "KW2"

set.seed(1849)
R <- 100
A <- array(0,c(n,2,R))

# Simulation Loop
for(i in 1:R) { 
	s <- sample(0:1,n,replace = TRUE)
	B0 <- s * rmvnorm(n, B[1,], Cov) + (1-s) * rmvnorm(n, B[2,], Cov)
	z <- rnorm(n)
	v <- rnorm(n)
	XB0 <- cbind(1,z,v) %*% t(B0)
	utility <- diag(cbind(1, z, v) %*% t(B0))
	y <- (utility > 0) - 0
	D <- data.frame(z = z, v = v, y = y)
	#fKW <- rcbr(y ~ z + v, data = D, mode = "KW")
	#fGK <- rcbr(y ~ z + v, data = D, mode = "GK")
	#glmfit <- glm(y ~ z + v, data = D, family = binomial(link = "logit"))
	fKS <- KS(y ~ z + v, D)
	X <- data.frame(z = rnorm(n), v = rnorm(n)) # Newdata
	ptrue <- predict(fT, newdata = X)
	pKS <- predict(fKS, newdata = X)
	A[,,i] = cbind(ptrue, pKS)
	print(i)
	}
