# DGP two discrete points Klein-Spady increment to simulation exercise
require(RCBR)
source("KleinSpady.R")

set.seed(1848)
sessionInfo()
R <- 100
B = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
fT <- list(u = B[,1], v = B[,2], uv = B[,1:2], W = c(.5,.5)) # The truth
class(fT) <- "KW2"
n <- 500

A <- array(0, c(n,2,R))
for(i in 1:R){
    z <- rnorm(n)
    v <- rnorm(n)
    XB <- cbind(1,z,v) %*% t(B)
    s <- sample(0:1, n, replace = TRUE)
    utility <- s * XB[,1] + (1-s) * XB[,2]
    y <- (utility > 0) - 0
    D <- data.frame(z = z, v = v, y = y)
    #GKfit <- rcbr(y ~ z + v, data = D, mode = "GK")
    #KWfit <- rcbr(y ~ z + v, data = D, mode = "KW")
    #glmfit <- glm(y ~ z + v, data = D, family = binomial(link = "logit"))
    KSfit = KS(y ~ z + v, D)
    X <- data.frame(x = rnorm(n), v = rnorm(n))
    pKS <- predict(KSfit, newdata = X)
    #pKW <- predict(KWfit, newdata = X)
    #pGK <- predict(GKfit,newdata = X)
    ptrue <- predict(fT, newdata = X)
    #pKWs <- predict(KWfit, newdata = X, smooth = 0.2)
    #pglm <- predict(glmfit, newdata = X, type = "response")
    A[,,i] <- cbind(ptrue,pKS)
    print(i)
}
