# DGP location mixture of two Gaussians
require(mvtnorm)
require(RCBR)
sessionInfo()

# true density from Gautier-Kitamura
n <- 500
B = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
Cov <- matrix(c(0.3,0.15,0,0.15,0.3,0,0,0,0),3,3)
u <- -40:40/20
v <- -40:40/20
du <- diff(u)[1]
dv <- diff(v)[1]
uv <- expand.grid(u,v)
w <- 0.5 * dmvnorm(uv, B[1,1:2], Cov[-3,-3]) + 0.5 * dmvnorm(uv, B[2,1:2], Cov[-3,-3])
w <- du * dv * w
fT <- list(u = u, v = v, uv = uv, W = w) # The truth
class(fT) <- "KW2"

set.seed(1849)
bws <- 0:3/10
R <- 100
A <- array(0,c(2+length(bws),2,R))

# Simulation Loop
pdf("sim1.pdf")
par(mfrow = c(2,2))
for(i in 1:R) { 
	s <- sample(0:1,n,replace = TRUE)
	B0 <- s * rmvnorm(n, B[1,], Cov) + (1-s) * rmvnorm(n, B[2,], Cov)
	z <- rnorm(n)
	v <- rnorm(n)
	XB0 <- cbind(1,z,v) %*% t(B0)
	utility <- diag(cbind(1, z, v) %*% t(B0))
	y <- (utility > 0) - 0
	D <- data.frame(z = z, v = v, y = y)
	fKW <- rcbr(y ~ z + v, data = D, mode = "KW")
	fGK <- rcbr(y ~ z + v, data = D, mode = "GK")
	glmfit <- glm(y ~ z + v, data = D, family = binomial(link = "logit"))
	X <- data.frame(z = rnorm(n), v = rnorm(n)) # Newdata
	ptrue <- predict(fT, newdata = X)
	pGK <- predict(fGK, newdata = X)
	pglm <- predict(glmfit, newdata = X, type = "response")
	plot(fGK)
	points(x = 0.7, y = -0.7, col = 2, pch = 16, cex = 2)
    	points(x = -0.7, y = 0.7, col = 2, pch = 16, cex = 2)
    	MAE <- mean(abs(pGK - ptrue))
    	RMSE <- sqrt(mean((pGK - ptrue)^2))
    	with(fT, contour(u,v,matrix(W, length(u), length(v)), col = "grey", add = TRUE))
    	title(paste("MAE = ", round(MAE,4), "RMSE = ", round(RMSE,4)), "Gautier-Kitamura") 
	A[1,,i] <- c(MAE, RMSE)
	for(j in 1:length(bws)) {
	  pKW <- predict(fKW, newdata = X, smooth = bws[j]) 
    	  MAE <- mean(abs(pKW - ptrue))
    	  RMSE <- sqrt(mean((pKW - ptrue)^2))
	    if(j > 1){
    		plot(fKW, smooth = bws[j], xlim = c(-2,2), ylim = c(-2,2))
    		plot(fKW, add = TRUE, inches = 1/10)
    		points(x = 0.7, y = -0.7, col = 2, pch = 16, cex = 2)
    		points(x = -0.7, y = 0.7, col = 2, pch = 16, cex = 2)
    		with(fT, contour(u,v,matrix(W, length(u), length(v)), col = "grey", add = TRUE))
    		title(paste("MAE = ", round(MAE,4), "RMSE = ", round(RMSE,4)), paste("bw = ", bws[j])) 
		}
	   A[1+j,,i] <- c(MAE,RMSE)
	   }
    	MAE <- mean(abs(pglm - ptrue))
    	RMSE <- sqrt(mean((pglm - ptrue)^2))
	A[2+length(bws),,i] <- c(MAE,RMSE)
	print(i)
	}
dev.off()
save.image("sim1.Rdata")
