# Klein-Spady semiparametric binary response estimator a la np
# Intended only for RCBR simulation exercise; caveat emptor!
# Note the need to restore the seed due to random generation in KS
require(np)
require(RCBR)
require(REBayes)

KS = function(formula, D){
    seed = get(".Random.seed", .GlobalEnv)
    bw = npindexbw(formula, data = D, optim.method = "BFGS", method = "kleinspady",
		   nmulti = 20, ckertype = "gaussian", ckerorder = 2)
    tms = terms(bw)
    m = match(c("formula", "data"), names(bw$call), nomatch = 0)
    tmf = bw$call[c(1,m)]
    tmf[[1]] = as.name("model.frame")
    tmf[["formula"]] = tms
    tmf = eval(tmf, envir = environment(tms))
    mt = attr(tmf, "terms")
    y <- model.response(tmf)
    X = model.matrix(mt, tmf) 
    b = npindex(bw, gradient = TRUE)$beta[2]
    Xb = X[,2] * b + X[,3]
    fhat = Cosslett(Xb, y, v = sort(Xb))
    z = list(b = b, fhat = fhat)
    assign(".Random.seed", seed, .GlobalEnv)
    class(z) ="KS"
    z
}
predict.KS = function(object, ...){
    dots <- list(...)
    if (!length(dots$newdata)) 
        stop("No newdata to predict at.")
    nd <- as.matrix(dots$newdata)
    fhat = object$fhat
    Fhat = stepfun(fhat$x,c(0,cumsum(fhat$y)))
    Xb = nd[,1] * object$b + nd[,2]
    Fhat(Xb)
}

# The following code was only used for debugging purposes....
if(FALSE){
data(Horowitz93)
D = Horowitz93
datsub = D[D$CARS == 1,]
bw = npindexbw(DEPEND~I(DCOST/100)+DOVTT, data = datsub,method = "kleinspady",
	       optim.method = "BFGS",nmulti=20,ckertype="gaussian",ckerorder=2)
model.index <- npindex(bw, gradient = TRUE)
}
if(FALSE){
n = 200
B = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
z = rnorm(n)
v = rnorm(n)
XB = cbind(1,z,v) %*% t(B)
s = sample(0:1, n, replace = TRUE)
utility = s * XB[,1] + (1-s) * XB[,2]
y = (utility > 0) - 0 
D = data.frame(z = z, v = v, y = y)
f = KS(y ~ v + z, D) # NB.  order of covariates matters!
X = data.frame(x = rnorm(n), v = rnorm(n))
phat = predict(f, newdata = X)
}

