require(REBayes)
require(Rmosek)

# implement Rada and Cerny (2018)
# SIAM J. Discrete Math.
# IE algorithm
# reduction function : eli.neighbour (find local maximum cells and the associated interior point)


witness <- function(A,B, s, verb = 1){
m = ncol(A)
n = nrow(A)
if (is.null(m)) {
	m = length(A)
	n = 1
	S = s
	}
Interior <- list()
Interior$sense <- "max"
Interior$c <- c(rep(0, m), 1)
if (length(s) >1) S <- diag(s)
A = cbind(S%*%A, matrix(-1, nrow = n,1))
Interior$A <- Matrix(A, sparse = TRUE)
buc <- c(rep(Inf, nrow(A)))
blc <- c(S%*%as.vector(B))
Interior$bc <- rbind(blc,buc)
blx <- c(rep(-Inf,m),-Inf)
bux <- c(rep(Inf,m),1)
Interior$bx <- rbind(blx,bux)
r <- mosek(Interior,opts = list(verbose = verb))
checkfeas <- r$sol$bas$xx[3]
list(w = r$sol$bas$xx[1:2],fail = (checkfeas <= 0), s = s)
}



# IE algorithm
# n = number of hyperplanes
	
IE <- function(A, B, print.progress = FALSE){
	# print function will allow progress as i gets larger 
n = nrow(A)
SignVector = NULL

initial = rep(0, 2)
i = 0
	if (t(as.vector(A[(1:(i+1)),]))%*%as.vector(initial)>B[(1:(i+1)),]){
		SignVector=c(SignVector, 1)
		w = initial
		} else {
		SignVector = c(SignVector,-1)
		w = initial
		}
		test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector * c(rep(1, i),-1))
		if (!test$fail){
			SignVector = cbind(SignVector, test$s)
			w = cbind(initial, c(test$w))
			}




for (i in 1:(n-1)){
	SignVector = rbind(SignVector, rep(NA, ncol(SignVector)))
	for (k in 1:ncol(SignVector)){
		if (A[(i+1),]%*%as.vector(w[,k])> B[(i+1),]){
			SignVector[,k] = c(SignVector[(1:i),k],1)	
			}else {
				SignVector[,k] = c(SignVector[(1:i),k],-1)
				}
				}
			for (l in 1:ncol(SignVector)){
				test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector[,l] * c(rep(1,i),-1))
				if (!test$fail){
					SignVector = cbind(SignVector, test$s)
					w = cbind(w, c(test$w))
					}
					}
					if (print.progress & round(i/10)==i/10) print(i)			
	}
	list(w = w, SignVector = SignVector)
	}


IE2 <- function(A, B, print.progress = FALSE){
	# print function will allow progress as i gets larger 
n = nrow(A)
SignVector = NULL

initial = matrix(rep(0, 2),ncol = 1)
i = 0
SignVector <- ifelse(t(as.vector(A[(1:(i+1)),]))%*%as.vector(initial)>B[(1:(i+1)),], c(SignVector, 1), c(SignVector,-1))
w = initial
test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector * c(rep(1, i),-1))
		if (!test$fail){
			SignVector = cbind(SignVector, test$s)
			w = cbind(initial, c(test$w))
			}

for (i in 1:(n-1)){
	SignVector = rbind(SignVector, rep(NA, ncol(SignVector)))
	inside <- apply(w, 2, function(x) (as.vector(x)%*%A[(i+1),]>B[(i+1),]))
	SignVector[(i+1),inside] = 1
	SignVector[(i+1),!inside] = -1
	test.fail = apply(SignVector, 2, function(x) witness(A[(1:(i+1)),], B[(1:(i+1)),], s = x*c(rep(1,i),-1))$fail)
	test.s = apply(SignVector[,!test.fail,drop = FALSE], 2, function(x) witness(A[(1:(i+1)),], B[(1:(i+1)),], s = x*c(rep(1,i),-1))$s)
	test.w = apply(SignVector[,!test.fail,drop = FALSE], 2, function(x) witness(A[(1:(i+1)),], B[(1:(i+1)),], s = x*c(rep(1,i),-1))$w)
	SignVector = cbind(SignVector,test.s)
	w = cbind(w, test.w)
	if (print.progress & round(i/10)==i/10) print(i)
	}
	list(w = w, SignVector = SignVector)
	}
	
	
	IEfast <- function(A, B, print.progress = FALSE){
	# pre-process to determine which cells creates new cells with addition of a hyperplane
n = nrow(A)
SignVector = NULL

initial = matrix(rep(0, 2),ncol = 1)
i = 0
SignVector <- ifelse(t(as.vector(A[(1:(i+1)),]))%*%as.vector(initial)>B[(1:(i+1)),], c(SignVector, 1), c(SignVector,-1))
w = initial
test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector * c(rep(1, i),-1))
		if (!test$fail){
			SignVector = cbind(SignVector, test$s)
			w = cbind(initial, c(test$w))
			}


for (i in 1:(n-1)){
SignVector = rbind(SignVector, rep(NA,ncol(SignVector)))
	inside <- apply(w, 2, function(x) (as.vector(x)%*%A[(i+1),]>B[(i+1),]))
	SignVector[(i+1),inside] = 1
	SignVector[(i+1),!inside] = -1
					
		# now pre-process to see which polygons creates new cells with the addition of a hyperplane		
			if (i > 1){
			vertex <- matrix(0, nrow = 2, ncol = i)
			for (k in 1:i){
				vertex[,k] <- solve(rbind(A[k,], A[(i+1),]), rbind(B[k,], B[(i+1),]))
				}
			feas <- matrix(1, nrow = i, ncol = i)
			feas2 <- matrix(-1,nrow = i, ncol = i)
			Atemp = A[1:i,]
			Btemp = B[1:i,,drop = FALSE]
			for (j in 1:i){
				feas[j, -j] <- sign(Atemp[-j,]%*%vertex[,j]-Btemp[-j,])
				feas2[j, -j] <- sign(Atemp[-j,]%*%vertex[,j]-Btemp[-j,])
				}	
			feaset <- rbind(feas, feas2)	# all possible sign vectors for active cells
			feaset <- unique(t(feaset),MARGIN=2)  #keep only the unique sign restrictions
			SS <-  apply(feaset,2,function(x) colSums(x==SignVector[1:i,]))
			colset <- c(1:ncol(SignVector))[apply(SS,1,function(x) any(x>=i))]
			}else{
				colset = c(1:ncol(SignVector))}

			for (l in colset){
				test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector[,l] * c(rep(1,i),-1))
				if (!test$fail){
					SignVector = cbind(SignVector, test$s)
					w = cbind(w, c(test$w))
					}
					}
					if (print.progress & round(i/10)==i/10) print(i)			
	}
	list(w = w, SignVector = SignVector)
	}


eli.neighbour <- function(x, SignVector){
	n <- nrow(SignVector)
	tem <- x - SignVector
	neighbour <- which(colSums(abs(tem))==2)
	count.neighbour <- apply(SignVector[,neighbour],2,function(x) (sum(x==1)))
	count.x <- sum(x==1)
	(count.x<max(count.neighbour))  # if true, then x should be eliminated from the SignVector
	}
	
	



# n = 5 example in the paper 
x = rbind(c(0.41,1.22), c(0.4,0.36),c(0.17,0.24), c(-0.79, 0.99), c(-0.94, 0.55))
X = cbind(1,x)
y = c(1,0,1,0,0)

B = matrix(-X[,3],ncol = 1)
A = cbind(1,X[,2])
n = 5
subset1 = c(1:n)[y==1]
subset0 = c(1:n)[y==0]


f = IE(A,B)

# post-processing based on the realization of y [if y_j = 0, then needs to reverse the sign of the j-th row of the SignVector]
SignVector = f$SignVector
SignVector[which(y==0),] = -SignVector[which(y==0),]

testeli = apply(SignVector, 2, eli.neighbour, SignVector = SignVector)	
 
loc.max = SignVector[,!testeli]
loc.witness = f$w[,!testeli]

pdf("eg5.pdf")

plot(NULL, xlim = c(-10,10), ylim = c(-10,10),xlab = expression(eta[1]),ylab = expression(eta[2]))
for (j in 1:sum(y)){
abline(a =X[subset1[j],3]/(-X[subset1[j],2]),b = -1/X[subset1[j],2],col=j)
}
for (k in 1:(n-sum(y))){
abline(a =X[subset0[k],3]/(-X[subset0[k],2]),b = -1/X[subset0[k],2],col= k+sum(y))
}

# highlight local max polygons
# polygon 1: line 1&4,3&4, 1& upper bound, 3 & upper bound
# polygon 2: line 2&4,2 & upper bound, 4 & upper bound
# polygon 3: line 2&3, 1&2, 1 & lower bound, 3 & lower bound

v14 = solve(A[c(1,4),], B[c(1,4),])
v24 = solve(A[c(2,4),], B[c(2,4),])
v1b = c((B[1,] - A[1,2]*10.8)/A[1,1],10.8)
v2b = c((B[2,] - A[2,2]*10.8)/A[2,1],10.8)	
pol1 = cbind(v14,v24,v2b,v1b)
polygon(x = pol1[1,],y = pol1[2,], col = "skyblue")
text(x = -2.8, y = 5, label = "C2", cex=0.8)

v34 = solve(A[c(3,4),], B[c(3,4),])
v3b = c((B[3,] - A[3,2]*10.8)/A[3,1],10.8)
v4b = c((B[4,] - A[4,2]*10.8)/A[4,1],10.8)
pol2 = cbind(v34,v3b,v4b)
polygon(x = pol2[1,],y = pol2[2,], col = "skyblue")
text(x =2 , y = 7, label = "C1", cex=0.8)


v23 = solve(A[c(2,3),], B[c(2,3),])
v13 = solve(A[c(1,3),], B[c(1,3),])
v1l = c((B[1,] + A[1,2]*10.8)/A[1,1],-10.8)
v2l = c((B[2,] + A[2,2]*10.8)/A[2,1],-10.8)
pol3 = cbind(v23,v13,v1l,v2l)
polygon(x = pol3[1,],y = pol3[2,], col = "skyblue")
text(x =1.8 , y = -6.5, label = "C3", cex=0.8)

text(x = -5, y = 8, label = "H1", cex=0.8)
text(x = -2.8, y = 7, label = "H2", cex = 0.8)
text(x = -1.5, y = 5, label = "H3", cex = 0.8)
text( x= 5, y = 7, label = "H4", cex = 0.8)
text(x = 4, y = 4, label = "H5", cex = 0.8)
dev.off()	
