# NB:  The figure produced by this file had trouble with pdf fonts for the ( and ] characters.
# My dubious solution was to make a quartz() figure and then use dev.copy2pdf() to make a pdf.
# Note also that there is a sign confusion relative to our usual conventions in the rcbr paper.
require(REBayes)


Counts <- function(y,x, eps = 1e-5) {
	n = length(y)
	if (length(unique(x))==n) u <- sort(x)
	else{ 
	    # when there are ties in x and their y disagree, break the tie by 
	    # shifting those x with y =0 to the right by a magnitude of shift
		shift <- min(abs(diff(unique(sort(x)))))/2  
	    nn <- names(table(x))[which(tapply(y,x,mean) != 0 & tapply(y,x,mean)!=1)] 
	    x[x %in% nn & y==0] <- x[x %in% nn & y==0]+shift
	    u <- sort(unique(x))
	    }
	m <- length(u)
	c <- rep(0,m+1)
	for(k in 1:m)
	    c[k] = sum(x[y==0]< u[k]) + sum(x[y==1]>= u[k])
	c[m+1] = sum(x[y==0]<= u[m])
	if (sum(diff(c)==0)>0){ 
	    # counts has flat regions, reduce to unique counts, and recover locations of local maxima
	    if (sum(diff(c)==0)==(length(c)-1))
        	localmax = 1:length(c)
	    else{
		loc <- which(diff(c)!=0) 
		id <- rep(1:(length(loc)+1), c(loc[1],diff(loc), length(c)-loc[length(loc)]))
		creduce = c[c(loc,max(loc)+1)]
		s <- sign(diff(creduce))
		ns = length(s)
		lmax <- which(s[-ns] - s[-1] == 2)
		if(s[1] == -1) lmax = c(0,lmax)
		if(s[ns] == 1 ) lmax = c(lmax,ns)
		localmax = c(1:length(c))[id%in%(lmax+1)]
	    }
	}
	else{
	    s <- sign(diff(c))
	    ns = length(s)
	    lmax <- which(s[-ns] - s[-1] == 2)
	    if(s[1] == -1) lmax = c(0,lmax)
	    if(s[ns] == 1 ) lmax = c(lmax,ns)
	    localmax = lmax+1
	    }
		list(lmax = localmax, counts = c)
		}
		
set.seed(11)

F = function(x) 0 * (x <= -1) + 1/2 * (x >= -1) + 1/2 * (x >= 1)
n = 10
v = rnorm(n)  #data
#eta = sample(c(-1,1),n,replace=TRUE,prob = c(1/2,1/2))
eta = rnorm(n)
y = (eta <= v)-0
k <- Counts(y,v)$counts  # n + 1 counts 
klmax <- Counts(y,v)$lmax
vo = sort(unique(v))

#pdf("Oned.pdf", height = 7, width = 7)
layout(matrix(c(1,2,2),3,1))
plot(v[y==1],sample(c(-1,1),sum(y),replace = TRUE), type = "n", axes = FALSE,  xlim = range(v),xlab = "", ylab = "")
text(v[y==1],rep(0,sum(y)), "]", cex = 2)
abline(h = 0)
text(v[y==0],rep(0,n-sum(y)), "(", cex = 2, col=2)
segments(c(vo[1]-0.1,vo)[klmax],c(0,0),c(vo[1]-0.1,vo)[klmax+1],c(0,0), col = 2, lwd = 2)  # (use right end point to represent interval)
plot(c(vo, vo[n]+0.1), k, type = "l", cex = 3, xlab = "v", ylab = "c")  # adjust the fact that there are n+1 interval
points(c(vo, vo[n]+0.1), k, pch = 16 )
#dev.off()
