# DGP two discrete points
require(mvtnorm)
plot.KW2 <- function(f, smooth = 0, add = FALSE, 
		     col = "steelblue2", tol = 0.001, ...){
    W <- f$W
    uv <- f$uv
    s <- (W > tol)
    D <- data.frame(w = W[s], x = f$uv[s,1], y = f$uv[s,2])
    if(smooth > 0){
	mu <- mv <- 40
	ru <- range(uv[s, 1])
        rv <- range(uv[s, 2])
        u <- seq(ru[1] - 4 * smooth, ru[2] + 4 * smooth, length = mu)
        v <- seq(rv[1] - 4 * smooth, rv[2] + 4 * smooth, length = mv)
        fs <- matrix(0, mu, mv)
        for (i in 1:mu) {
            for (j in 1:mv) {
                Z <- cbind(u[i] - uv[, 1], v[j] - uv[, 2])
                fs[i, j] <- sum(mvtnorm::dmvnorm(Z, sigma = diag(2) * smooth) * W)
            }
        }
	contour(u, v, matrix(fs,mu,mv), ...)
    }
    else
	with(D, symbols(x = x, y = y, circles = w, inches = 1/5, 
			bg = col, fg = NULL, add = add))
}

# X is (1, x_1, X_2) with Gaussian x's
# X is normalized to have rows of unit length, 

set.seed(1842)
B0 = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
n <- 500
m = 50
z <- rnorm(n)
v <- rnorm(n)
XB0 <- cbind(1,z,v) %*% t(B0)
s <- sample(0:1, n, replace = TRUE)
utility <- s * XB0[,1] + (1-s) * XB0[,2]
y <- (utility > 0) - 0
D <- data.frame(z = z, v = v, y = y)
if(FALSE){
f <- rcbr(y ~ z + v, data = D, mode = "KW")
}
load("KW0.Rda")
pdf("KW0.pdf")
#contour(u,v,f$fd) # Discrete KW estimate
#contour(u,v,f$fs,add = TRUE) # Smoothed contours
plot(f, smooth = .2, xlim = c(-2,2), ylim = c(-2,2), xlab = expression(eta[1]), ylab = expression(eta[2]))
plot(f, add = TRUE)
points(x = 0.7, y = -0.7, col = 2, pch = 20)
points(x = -0.7, y = 0.7, col = 2, pch = 20)
dev.off()
