# illustration of the IE algorithm: 
require(Rmosek)
witness <- function(A,B, s, verb = 1){
m = ncol(A)
n = nrow(A)
if (is.null(m)) {
	m = length(A)
	n = 1
	S = s
	}
Interior <- list()
Interior$sense <- "max"
Interior$c <- c(rep(0, m), 1)
if (length(s) >1) S <- diag(s)
A = cbind(S%*%A, matrix(-1, nrow = n,1))
Interior$A <- Matrix(A, sparse = TRUE)
buc <- c(rep(Inf, nrow(A)))
blc <- c(S%*%as.vector(B))
Interior$bc <- rbind(blc,buc)
blx <- c(rep(-Inf,m),-Inf)
bux <- c(rep(Inf,m),2)
Interior$bx <- rbind(blx,bux)
r <- mosek(Interior,opts = list(verbose = verb))
checkfeas <- t(as.vector(Interior$c))%*%as.vector(r$sol$bas$xx)
list(x = r$sol$bas$xx[1], y = r$sol$bas$xx[2],fail = (checkfeas <= 0), s = s)
}
IE <- function(A, B, print.progress = FALSE){
	# print function will allow progress as i gets larger 
n = nrow(A)
SignVector = NULL

initial = rep(0, 2)
i = 0
	if (t(as.vector(A[(1:(i+1)),]))%*%as.vector(initial)>B[(1:(i+1)),]){
		SignVector=c(SignVector, 1)
		w = initial
		} else {
		SignVector = c(SignVector,-1)
		w = initial
		}
		test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector * c(rep(1, i),-1))
		if (!test$fail){
			SignVector = cbind(SignVector, test$s)
			w = cbind(initial, c(test$x,test$y))
			}

for (i in 1:(n-1)){
	SignVector = rbind(SignVector, rep(NA, ncol(SignVector)))
	for (k in 1:ncol(SignVector)){
		if (A[(i+1),]%*%as.vector(w[,k])> B[(i+1),]){
			SignVector[,k] = c(SignVector[(1:i),k],1)	
			}else {
				SignVector[,k] = c(SignVector[(1:i),k],-1)
				}
				}
			for (l in 1:ncol(SignVector)){
				test = witness(A[(1:(i+1)),], B[(1:(i+1)),], s = SignVector[,l] * c(rep(1,i),-1))
				if (!test$fail){
					SignVector = cbind(SignVector, test$s)
					w = cbind(w, c(test$x,test$y))
					}
					}
					if (print.progress & round(i/10)==i/10) print(i)			
	}
	list(w = w, SignVector = SignVector)
	}


eli.neighbour <- function(x, SignVector){
	n <- nrow(SignVector)
	tem <- x - SignVector
	neighbour <- which(apply(tem, 2, function(x) (sum(x==0)==(n-1))))
	count.neighbour <- apply(SignVector[,neighbour],2,function(x) (sum(x==1)))
	count.x <- sum(x==1)
	(count.x<max(count.neighbour))  # if true, then x should be eliminated from the SignVector
	}
	
	
pdf("IEill.pdf", width = 10, height = 5)
par(mfrow=c(1,2))
A = rbind(c(-1,1), c(1,1), c(0.2,1))
B = rbind(1,1,-2)
plot(NULL,xlim = c(-10,10), ylim = c(-10,10), xlab = expression(eta[1]), ylab = expression(eta[2]), main = "Output at Iteration 2")
for (i in 1:2){
 abline(a = B[i,1]/A[i,2], b = -A[i,1]/A[i,2],col = 1)
 }

f = IE(A[-3,],B[-3,,drop = FALSE])
set = c("A","B","C","D")
set2 = c("- -","+ +","- +","+ -")
x <- f$w[1,] + c(0, 0, 2, -2)
y <- f$w[2,] + c(-2, 2, 1, 1)

	for (k in 1:ncol(f$w)){
		points(x[k],y[k],cex = 0.5, pch = 16)
		text(x[k],y[k], labels = set[k], cex = 0.8, font = 6, pos = 2)
		text(x[k],y[k], labels = set2[k], cex = 0.8, font = 12, pos = 1)
		}
text(x=5,y = 5, labels = expression(H[1]), cex = 0.8)
text(x = -5,y = 5, labels = expression(H[2]),cex = 0.8)
	
plot(NULL,xlim = c(-10,10), ylim = c(-10,10),xlab = expression(eta[1]), ylab = expression(eta[2]),main = "Output at Iteration 3")
for (i in 1:2){
 abline(a = B[i,1]/A[i,2], b = -A[i,1]/A[i,2],col = 1)
 }
 
abline(a = B[3,1]/A[3,2], b = -A[3,1]/A[3,2],lty = 2) 
f2 = IE(A,B)
set3 = c("A","B","C","D","E","F","G")
set4 = c("- - +", "+ + +","- + +","+ - +", "- - -", "- + -","+ - -")
x <- f2$w[1,] + c(0, 0, 3, -2, 1, 1, -2)
y <- f2$w[2,] + c(-0.5, 3, 0, 1, -1, 0, 0)

for (k in 1:4){
		points(x[k],y[k],cex = 0.5, pch = 16)
		text(x[k],y[k], labels = set3[k], cex = 0.8, font = 6, pos = 2)
		text(x[k],y[k], labels = set4[k], cex = 0.8, font = 12, pos = 1)
		}
for (k in 5:ncol(f2$w)){
		points(x[k],y[k],cex = 0.5, pch = 4)
		text(x[k],y[k], labels = set3[k], cex = 0.8, font = 6, pos = 2)
		text(x[k],y[k], labels = set4[k], cex = 0.8, font = 12, pos = 1)
		}
	text(x=5,y = 5, labels = expression(H[1]), cex = 0.8)
text(x = -5,y = 5, labels = expression(H[2]), cex = 0.8)
text(x = -8, y = -1, labels = expression(H[3]), cex = 0.8)		
dev.off()
