# DGP location mixture of two Gaussians
require(mvtnorm)
require(RCBR)


set.seed(1848)
n <- 500
B = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
Cov <- matrix(c(0.3,0.15,0,0.15,0.3,0,0,0,0),3,3)
s <- sample(0:1,n,replace = TRUE)
B0 <- s * rmvnorm(n, B[1,], Cov) + (1-s) * rmvnorm(n, B[2,], Cov)
z <- rnorm(n)
v <- rnorm(n)
XB0 <- cbind(1,z,v) %*% t(B0)
utility <- diag(cbind(1, z, v) %*% t(B0))
y <- (utility > 0) - 0
D <- data.frame(z = z, v = v, y = y)
f <- rcbr(y ~ z + v, data = D, mode = "GK")

# Over plot true density contours
u <- -40:40/20
v <- -40:40/20
du <- diff(u)[1]
dv <- diff(v)[1]
uv <- expand.grid(u,v)
w <- 0.5 * dmvnorm(uv, B[1,1:2], Cov[-3,-3]) + 0.5 * dmvnorm(uv, B[2,1:2], Cov[-3,-3])
w <- du * dv * w
fT <- list(u = u, v = v, uv = uv, W = w) # The truth
class(fT) <- "KW2"


pdf("GK1.pdf")
plot(f,  xlim = c(-2,2), ylim = c(-2,2), , xlab = expression(eta[1]), ylab = expression(eta[2]))
points(x = 0.7, y = -0.7, col = 2, pch = 16, cex = 2)
points(x = -0.7, y = 0.7, col = 2, pch = 16, cex = 2)
with(fT, contour(u,v,matrix(W, length(u), length(v)), col = "grey", add = TRUE))
dev.off()
