# DGP two discrete points
require(mvtnorm)
require(RCBR)

set.seed(1842)
B0 = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
n <- 500
m = 50
z <- rnorm(n)
v <- rnorm(n)
XB0 <- cbind(1, z, v) %*% t(B0)
s <- sample(0:1, n, replace = TRUE)
utility <- s * XB0[,1] + (1-s) * XB0[,2]
y <- (utility > 0) - 0
D = data.frame(z = z, v = v, y = y)

b <- seq(-2,2,by = 0.1)
B <- cbind(expand.grid(b,b),1)
d <- sqrt(apply(B^2, 1, sum))
B <- B/d
B <- as.matrix(B)

pdf("GK0.pdf", height = 6, width = 10)
par(mfrow = c(1,2))
fb <- rcbr(y ~ z + v , data = D, mode = "GK")
#contour(u,v,f$fd) # Discrete KW estimate
#contour(u,v,f$fs,add = TRUE) # Smoothed contours
#points(x = 0.7, y = -0.7, col = 2)
#points(x = -0.7, y = 0.7, col = 2)
contour(b,b,matrix(100 * fb$w,length(b)), xlab = expression(eta[1]), ylab = expression(eta[2]))
points(x = 0.7, y = -0.7, col = 2, pch = 16, cex = 2)
points(x = -0.7, y = 0.7, col = 2, pch = 16, cex = 2)
fb <- rcbr(y ~ z + v , data = D, mode = "GK", T = 7)
# Transform back to R^2 ???
#contour(u,v,f$fd) # Discrete KW estimate
#contour(u,v,f$fs,add = TRUE) # Smoothed contours
#points(x = 0.7, y = -0.7, col = 2)
#points(x = -0.7, y = 0.7, col = 2)
contour(b,b,matrix(100*fb$w,length(b)), xlab = expression(eta[1]), ylab = expression(eta[2]))
points(x = 0.7, y = -0.7, col = 2, pch = 16, cex = 2)
points(x = -0.7, y = 0.7, col = 2, pch = 16, cex = 2)
dev.off()
