
# Compare computation time of n-constrained NPMLE and local-max NPMLE.
# local-max NPMLE reduces the number of grid points by finding local max
# much faster (at least 30 times) for n moderately large [i.e. > 1000]

set.seed(523)

require(RCBR)
m <- 100
A <- matrix(0,m,3)
for(i in 1:m){
    n <- round(exp(runif(1,5,9)))
    v <- rnorm(n)
    eta <- rnorm(n)
    y <- (eta <= v)-0
    f <- rcbr(y ~ v, mode = "KW")
    A[i,] <- (c(n, length(f$x), sum(f$y > 0.001)))
}
