# The data (no jittering)

require(RCBR)
data(Horowitz93)
D <- Horowitz93
main <- paste("Travelers with",c("no car","one car","two cars"))
xlab <- expression(paste(Delta, " travel cost ($/trip)"))
ylab <- expression(paste(Delta, " travel time (mins/trip)"))
pdf("datavis.pdf",height = 6, width = 10)
par(mfrow = c(1,3)) 
for(i in 0:2){
    s <- (D$CARS== i)
    dcost <- D$DCOST[s]/100  # $/trip
    dtime <- D$DOVTT[s]   # Minutes/trip	
    plot(dcost, dtime, main = main[i+1], cex.lab = 1.5, xlab = xlab, ylab = ylab)
    points(dcost[D$DEPEND==0], dtime[D$DEPEND==0], col=4,pch = 20)
}
dev.off()
