# New version of plot of Fhets for Horowitz Data
require(RCBR)
data(Horowitz93)

D <- Horowitz93
y <- D$DEPEND
v <- D$DCOST/100
z <- D$DOVTT
k <- D$CARS
D0 <- data.frame(z = z, v = v, y = y)[k == 2,]
#fKW <- rcbr(y ~ z + v, data = D0, mode = "KW", initial = c(-2,-1), epsbound = 0.01)
#fGK <- rcbr(y ~ z + v, data = D0, mode = "GK", T = 2, TX = 3)
load("car2.Rda") #  the prior two lines take about 2 minutes on my laptop


pdf("car2.pdf",height = 6, width = 9)
plot(NULL, xlim = c(-2.5,2.5),ylim = c(-1, 2),xlab = expression(eta[1]), ylab = expression(eta[2]))
plot(fKW, add = TRUE)
contour(fGK$u, fGK$v, matrix(fGK$w,length(fGK$u)), col = "grey", drawlabels = FALSE, add = TRUE)
dev.off()


s <- fKW$W > 0.001
A <- cbind(fKW$uv, fKW$W)[s,]
o <- order(-A[,3])
A <- round(A[o,],4)
dimnames(A)[[2]] <- c("$\\eta_1$", "$\\eta_2$", "p")
cap <- "Mass points of the estimated distribution of coefficients for commuters with two cars:  
The first two columns indicate interior points of cells containing estimated mass given by
the third column of the table"
latex(A, file = "car2.tex", caption = cap, caption.loc = "bottom")
