# New version of plot of Fhets for Horowitz Data
require(RCBR)
require(Hmisc)
data(Horowitz93)

D <- Horowitz93
y <- D$DEPEND
v <- D$DCOST/100
z <- D$DOVTT
k <- D$CARS
D0 <- data.frame(z = z, v = v, y = y)[k == 1,]
#fKW <- rcbr(y ~ z + v, data = D0, mode = "KW", initial = c(0.02,-0.01), epsbound = 0.1)
#fGK <- rcbr(y ~ z + v, data = D0, mode = "GK", T = 2, TX = 3)
load("car1.Rda") #  the prior two lines take about 5 minutes on my laptop


pdf("car1.pdf",height = 6, width = 9)
plot(NULL, xlim = c(-15,15),ylim = c(-1, 2),xlab = expression(eta[1]), ylab = expression(eta[2]))
plot(fKW, add = TRUE)
contour(fGK$u, fGK$v, matrix(fGK$w,length(fGK$u)), col = "grey", drawlabels = FALSE, add = TRUE)
dev.off()

s <- fKW$W > 0.001
A <- cbind(fKW$uv, fKW$W)[s,]
o <- order(-A[,3])
A <- round(A[o,],4)
dimnames(A)[[2]] <- c("$\\eta_1$", "$\\eta_2$", "p")
cap <- "Mass points of the estimated distribution of coefficients for commuters with 1 car:  
The first two columns indicate interior points of cells containing estimated mass given by
the third column of the table"
latex(A, file = "car1.tex", caption = cap, caption.loc = "bottom")
