# Combined table of estimated NPMLE mass points
require(Hmisc)
Tab <- NULL
for(i in 0:2){
    T <- matrix(NA, 20,3)
    load(paste("car", i, ".Rda", sep = ""))
    s <- fKW$W > 0.001
    A <- cbind(fKW$uv, fKW$W)[s,]
    o <- order(-A[,3])
    A <- round(A[o,],4)
    T[1:nrow(A),] <- A
    Tab <- cbind(Tab, T)
}
dimnames(Tab)[[2]] <- rep(c("$\\eta_1$", "$\\eta_2$", "p"),3)
cap <- "Mass points of the estimated distribution of coefficients for commuters:  
    The first two columns in each panel indicate interior points of cells containing the estimated mass given by
    the third column of each panel.  Only mass points with mass greater than 0.001 are displayed."
latex(Tab, file = "car012.tex", rowlabel = "", cgroup = c("No Car", "One Car", "Two Cars"), 
      caption = cap, caption.loc = "bottom", label = "tab:car012")
