# New version of plot of Fhets for Horowitz Data
require(RCBR)
data(Horowitz93)

D <- Horowitz93
y <- D$DEPEND
v <- D$DCOST/100
z <- D$DOVTT
k <- D$CARS
D0 <- data.frame(z = z, v = v, y = y)[k == 0,]
#fKW <- rcbr(y ~ z + v, data = D0, mode = "KW", initial = c(0.02,-0.01), epsbound = 0.05)
#fGK <- rcbr(y ~ z + v, data = D0, mode = "GK", T = 2, TX = 3)
load("car0.Rda")


pdf("car0.pdf",height = 6, width = 9)
plot(NULL, xlim = c(-9,1),ylim = c(-1.5, 1.5),xlab = expression(eta[1]), ylab = expression(eta[2]))
plot(fKW, add = TRUE)
contour(fGK$u, fGK$v, matrix(fGK$w,length(fGK$u)), col = "grey", drawlabels = FALSE, add = TRUE)
dev.off()


s <- fKW$W > 0.001
A <- cbind(fKW$uv, fKW$W)[s,]
o <- order(-A[,3])
A <- round(A[o,],4)
dimnames(A)[[2]] <- c("$\\eta_1$", "$\\eta_2$", "p")
cap <- "Mass points of the estimated distribution of coefficients for commuters with no car:  
The first two columns indicate interior points of cells containing estimated mass given by
the third column of the table"
latex(A, file = "car0.tex", caption = cap, caption.loc = "bottom")
