load("MEbounds.Rda")
require(lattice)

if(FALSE){  # Old version
pdf("MEboundsa.pdf", height = 10, width = 12)
col = rep(gray(0, 0.5), length.out = 2)
border = col[2]

par(mfcol = c(2,3))
for(k in 1:3){
	plot(rep(dv,2), c(pc[1,,k,2], pc[1,,k,3]), type = "n", cex.lab = 2,
	     ylim = range(pc[1,,k,2],pc[2,,k,2], pc[1,,k,3]), xlim = range(dv),
	     xlab = "reduction in fare ($)", ylab = "Change in transit probability")
	polygon(c(dv,rev(dv)), c(pc[1,,k,2], rev(pc[1,,k,3])), col = col[2], border = border)
	points(dv, pc[2,,k,1], col=2, pch = 20)
	plot(rep(dt,2), c(pt[1,,k,2], pt[1,,k,3]), type = "n", cex.lab = 2,
	    ylim = range(pt[1,,k,2],pt[2,,k,1], pt[1,,k,3]), xlim = range(dt), 
	    xlab = "reduction transit time (min)", ylab = "Change in transit probability")
	polygon(c(dt,rev(dt)), c(pt[1,,k,2], rev(pt[1,,k,3])), col = col[2], border = border)
	points(dt,pt[2,,k,1],col=2,pch  =20)
}
dev.off()
}

panel.bounds <- function(x,y, up, lo, gk, col, col.line, lwd, subscripts, ...) {
    up <- up[subscripts]
    lo <- lo[subscripts]
    gk <- gk[subscripts]
    panel.polygon(c(x, rev(x)), c(up, rev(lo)), col = "blue", lwd = 2, border = TRUE, ...)
    panel.xyplot(x, gk, col.line = "red", lwd = 2, ...)
}
D <- data.frame(x = rep(dv,3), y = c(pc[1,,,1]), lo = c(pc[1,,,2]), up = c(pc[1,,,3]), 
		k = as.factor(rep(0:2, each = 21)), gk = c(pc[2,,,1]))
#quartz(height = 5, width = 10)

MEv <- xyplot(y ~ x | k, data = D, groups = k, up = D$up, lo = D$lo, gk = D$gk, 
	     xlab = "reduction in fare ($)", ylab = "Change in transit probability",
	     strip = function(..., strip.name) strip.default(..., strip.names = TRUE),
	     panel = function(x, y, ...){
		panel.superpose(x,y, panel.groups = panel.bounds, type = "l", ...)
	    }  
)
D <- data.frame(x = rep(dt,3), y = c(pt[1,,,1]), lo = c(pt[1,,,2]), up = c(pt[1,,,3]), 
		k = as.factor(rep(0:2, each = 15)), gk = c(pt[2,,,1]))
MEt <- xyplot(y ~ x | k, data = D, groups = k, up = D$up, lo = D$lo, gk = D$gk, 
	     xlab = "reduction in transit time (mins)", ylab = "Change in transit probability",
	     strip = function(..., strip.name) strip.default(..., strip.names = TRUE),
	     panel = function(x, y, ...){
		panel.superpose(x,y, panel.groups = panel.bounds, type = "l", ...)
	    }  
)
pdf(file = "MEv.pdf", height = 5, width = 10)
plot(MEv)
dev.off()

pdf(file = "MEt.pdf", height = 5, width = 10)
plot(MEt)
dev.off()

