# Marginal Effects Bounds 

require(RCBR)
data(Horowitz93)
D <- Horowitz93

set.seed(1848) # Note random perturbation of newdata
dv = seq(0, 1, by = 0.05)
dt = seq(1, 15, by = 1)
pc <- array(0, c(2, length(dv),3, 3))
pt <- array(0, c(2, length(dt),3, 3))

for(k in 0:2){
    load(paste("car",k,".Rda", sep =""))
    y <- D[D$CARS == k, "DEPEND"]
    t75 <- quantile(fKW$x[y == 1, 2], 0.75) + runif(1,-1,1)/1000
    v75 <- quantile(fKW$x[y == 1, 3], 0.75) + runif(1,-1,1)/1000
    pinitial <- bounds.KW2(fKW, newdata = c(1, t75, v75))
    for (i in 1:length(dv)){
	pc[1,i, k+1,1] = predict(fKW, newdata = c(t75, v75)) - predict(fKW,newdata = c(t75, v75 - dv[i]))
	pc[2,i, k+1,1:3] = rep(predict(fGK, newdata = c(t75, v75)) - predict(fGK, newdata = c(t75, v75 - dv[i])),3)
	pctemp = bounds.KW2(fKW, newdata = c(1, t75, v75-dv[i]))
	pc[1,i,k+1,2:3] = c(pinitial$lower - pctemp$upper, pinitial$upper - pctemp$lower)
    }
    for (i in 1:length(dt)){
	pt[1,i, k+1,1] = predict(fKW, newdata = c(t75, v75)) - predict(fKW,newdata = c(t75 - dt[i], v75 ))
	pt[2,i ,k+1,1:3] = rep(predict(fGK, newdata = c(t75, v75)) - predict(fGK,newdata = c(t75 - dt[i], v75)),3)
	pttemp = bounds.KW2(fKW, newdata = c(1, t75-dt[i], v75))
	pt[1,i,k+1,2:3] = c(pinitial$lower - pttemp$upper, pinitial$upper - pttemp$lower)
    }
    print(k)
}
