source("GK.R")
G <- read.table("Horowitz93.txt")
G <-  G[,c(1,2,3,4,6)]
# DCOST: difference in cost of car versus transit (transit - car)
# CARS: number of cars at home 
# DOVTT: difference in out of vehicle time (transit - car)
# DIVTT: difference in in vehicle time (transit - car)
# DEPEND: value 1 means car, 0 means transit
Ts = c(1,2,3,4,5,7,9)
TXs = c(3,5,10,15,20)
U = cbind(seq(-10,3,length = 600), seq(-12,12,length = 600), seq(-3,3,length = 600))
v = seq(-2,2,length = 300)
GKL <- array(0, c(length(Ts), length(TXs),3))
for(k in 0:2){
  D <- G[G$CARS==k,]
  X <- cbind(1,D$DOVTT, D$DCOST/100)
  y <- D$DEPEND
  for (i in 1:length(Ts)){
        for (j in 1:length(TXs)){
            z <- GK(X,y, U[,k+1], v, T = Ts[i], TX = TXs[j])
            GKL[i,j,k+1] <- logLik(z)
        }
     }
}
