# Attempt to rerun Bruce Hansen's simulation see slides and random.R for his setup

R = 1000
Ns = c(100,200,500,1000)
Vs = c(0.1,0.5,1,2)
A = array(NA, c(3, length(Vs), length(Ns), R))
require(REBayes)
set.seed(1492)
sessionInfo()

# Experiment 1:  Normal-Gamma Model
for(i in 1:length(Vs)){
    s = sqrt(Vs[i])
    for(j in 1:length(Ns)){
	n = Ns[j]
	for(k in 1:R){
	    t = rgamma(n, 6*s, 3)
	    y = t + rnorm(n)
	    f = GLmix(y)
	    yhat = predict(f, y)
	    cu = predict(f, y, Loss = 0.975)
	    cl = predict(f, y, Loss = 0.025)
	    mse = mean((t - yhat)^2)
	    coverage = mean((cl < t) & (t < cu))
	    cilength = mean(cu - cl)
	    A[,i,j,k] = c(mse, coverage, cilength)
	}
    }
}
