# Attempt to reproduce Bruce Hansen's simulations of Armstrong et al

# Three simulation settings all Gaussian sequence model

#Setting 1

R = 1000
Ns = c(100,200,500,1000)
Vs = c(0.1,0.5,1,2)
A = array(0, c(3, length(Vs), length(Ns), R))
require(ebci)
set.seed(1492)
sessionInfo()

# Experiment 1:  Normal-Normal Model
for(i in 1:length(Vs)){
    s = sqrt(Vs[i])
    for(j in 1:length(Ns)){
	n = Ns[j]
	for(k in 1:R){
	    t = rnorm(n)*s
	    y = t + rnorm(n)
	    S = mean(y^2)
	    if(S > 1){
		w = 1 - 1/S
		mu = 1/sqrt(S - 1)
		cv = w * cva(mu, Inf)$cv
	    }
	    else{
		w = 1
		cv = 0
	    }
	    yhat = w * y
	    cu = yhat + cv
	    cl = yhat - cv
	    mse = mean((t - yhat)^2)
	    coverage = mean((cl < t) & (t < cu))
	    cilength = mean(cu - cl)
	    A[,i,j,k] = c(mse, coverage, cilength)
	}
    }
}
