# Replace discrete mixing with Gaussian mixing distribution Oracle comparison

require(doMC) #loads multicore and foreach automatically.
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1968)
opt <- list(set.seed = FALSE)

g <- function(y,a,v) a * dnorm(y) + (1 - a) * dnorm(y, v, sqrt(2))
gp <- function(y,a,v) -y * a * dnorm(y) - (1 - a) * (y - v) * dnorm(y, v, sqrt(2))/2
Tweedie <- function(y,a,v){
    # Gaussian signal plus point mass at zero Tweedie formula
    y + gp(y,a,v)/g(y,a,v)
}

n <- 500
R <- 1000
as <- c(25,50,100)
vs <- 1:5
registerDoMC(length(vs)) 
A <- array(0,c(R, length(as), 2))
AK <- foreach(k = 1:length(vs), .options.multicore = opt) %dopar% {
    v <- vs[k]
    for(j in 1:length(as)) {
	a <- 1 - as[j]/n
	for(i in 1:R){
            m <- sample(0:1,n,prob = c(a,1-a), replace = TRUE)*rnorm(n,v)
	    x <- m + rnorm(n)
	    A[i,j,1] <- mean((Tweedie(x,a,v) - m)^2)
	    A[i,j,2] <- mean((GLmix(x)$dy - m)^2)
	}
    }
    A
}
