# Simulation exercise to compare EBKM to the Oracle

require(doMC) #loads multicore and foreach automatically.
registerDoMC(4) # intention to use 4 cores
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1968)
opt <- list(set.seed = FALSE)



Odelta <- function(y,f){
    A <- dnorm(outer(y,f$v, "-"))
    (A %*% (f$fv * f$v))/(A %*% f$fv)
}

n <- 200
R <- 1000
sn <- c(10,20,40,80)
as <- c(1,3,5,7)
A <- array(0,c(R, length(sn), 2))
AK <- foreach(k = 1:length(sn), .options.multicore = opt) %dopar% {
    a <- as[k]
    for(j in 1:length(sn)) {
	s <- sn[j]
	m <- c(rep(a,s),rep(0,n-s))
	f <- list(v = c(0,a), fv = c(s/n,1-s/n))
	m <- sample(c(0,a),n,prob = c(s/n,1-s/n), replace = TRUE) 
	for(i in 1:R){
	    x <- m + rnorm(n)
	    A[i,j,1] <- mean((Odelta(x,f) - m)^2)
	    A[i,j,2] <- mean((GLmix(x)$dy - m)^2)
	}
    }
    A
}
