# A revised version of the Martin Walker code that might be faster


MWGibbs <- function(x, k = .99 , a = 0.25, v = 100, M = 1000) {
  # Added Martin-Walker defaults, see ebsparse.R in this directory
  n <- length(x)
  A <- matrix(0, M, n)
  for(i in 1:M) {
    if(i == 1) D <- sum(abs(x) <= sqrt(2 * log(n))) 
    else D <- sum(A[i-1,] == 0)
    w <- rbeta(1, a * n + D, 1 + n - D)
    u <- runif(n)
    p1 <- w * exp(-k * x^2 / 2) 
    p2 <- (1 - w) / sqrt(1 + k * v)
    p <- p1 / (p1 + p2)
    z <- rnorm(n, x, sqrt(v / (1 + k * v))) 
    A[i,] <- (u > p) * z
  }
  apply(A, 2, mean)
}

eb.gibbs <- function(X, k = .99 , a = 0.25, v = 100, M = 1000) {
  # Added Martin-Walker defaults, see ebsparse.R in this directory
  n <- length(X)
  theta <- matrix(0, nrow=M, ncol=n)
  W <- numeric(M)
  for(m in 1:M) {
    if(m == 1) D <- sum(abs(X) <= sqrt(2 * log(n))) else D <- sum(theta[m-1,] == 0)
    w <- rbeta(1, a * n + D, 1 + n - D)
    W[m] <- w
    for(i in 1:n) {
      u <- runif(1)
      prob <- c(w * exp(-k * X[i]**2 / 2), (1 - w) / sqrt(1 + k * v))
      p <- prob[1] / sum(prob)
      if(u <= p) tt <- 0 else tt <- X[i] + sqrt(v / (1 + k * v)) * rnorm(1)
      theta[m,i] <- tt
    }
  }
  apply(theta, 2, mean)
}
require(REBayes)
n <- 500
m <- sample(c(0,3),n,prob = c(.9,.1), replace = TRUE) + 10
x <- rnorm(n,m) 
t0 <- system.time(m0 <- mean((eb.gibbs(x)-m)^2))
t1 <- system.time(m1 <- mean((MWGibbs(x)-m)^2))
t2 <- system.time(m2 <- mean((GLmix(x)$dy-m)^2))
