# Simulation exercise to compare KWEB to the Martin-Walker Procedure

require(doMC) #loads multicore and foreach automatically.
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1968)
opt <- list(set.seed = FALSE)

Odelta <- function(y,f){
    A <- dnorm(outer(y,f$v, "-"))
    (A %*% (f$fv * f$v))/(A %*% f$fv)
}

n <- 500
R <- 1000
sn <- c(25,50,100)
as <- 1:5
registerDoMC(length(as)) 
A <- array(0,c(R, length(sn), 2))
AK <- foreach(k = 1:length(as), .options.multicore = opt) %dopar% {
    a <- as[k]
    for(j in 1:length(sn)) {
	s <- sn[j]
	f <- list(v = c(a,0), fv = c(s/n,1-s/n))
	m <- sample(c(a,0),n,prob = c(s/n,1-s/n), replace = TRUE) 
	for(i in 1:R){
	    x <- m + rnorm(n)
	    A[i,j,1] <- mean((Odelta(x,f) - m)^2)
	    A[i,j,2] <- mean((GLmix(x)$dy - m)^2)
	}
    }
    A
}


