# Simulation exercise to compare KWEB to the Martin-Walker Procedure

require(doMC) #loads multicore and foreach automatically.
registerDoMC(4) # intention to use 4 cores
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1968)
opt <- list(set.seed = FALSE)

eb.gibbs <- function(X, k = .99 , a = 0.25, v = 100, M = 1000) {
  # Added Martin-Walker defaults, see ebsparse.R in this directory
  n <- length(X)
  theta <- matrix(0, nrow=M, ncol=n)
  W <- numeric(M)
  for(m in 1:M) {
    if(m == 1) D <- sum(abs(X) <= sqrt(2 * log(n))) else D <- sum(theta[m-1,] == 0)
    w <- rbeta(1, a * n + D, 1 + n - D)
    W[m] <- w
    for(i in 1:n) {
      u <- runif(1)
      prob <- c(w * exp(-k * X[i]**2 / 2), (1 - w) / sqrt(1 + k * v))
      p <- prob[1] / sum(prob)
      if(u <= p) tt <- 0 else tt <- X[i] + sqrt(v / (1 + k * v)) * rnorm(1)
      theta[m,i] <- tt
    }
  }
  apply(theta, 2, mean)
}

n <- 200
R <- 1000
sn <- c(10,20,40,80)
as <- c(1,3,5,7)
A <- array(0,c(R, length(sn), 2))
AK <- foreach(k = 1:length(sn), .options.multicore = opt) %dopar% {
    a <- as[k]
    for(j in 1:length(sn)) {
	s <- sn[j]
	m <- c(rep(a,s),rep(0,n-s))
	for(i in 1:R){
	    x <- m + + rnorm(n)
	    A[i,j,1] <- mean((eb.gibbs(x) - m)^2)
	    A[i,j,2] <- mean((GLmix(x)$dy - m)^2)
	}
    }
    A
}


