# nt1-10 lattice plot construction
#require(lattice)
load("nt1-10.Rda")
meths = c("Tailp", "TailpE","TailpKW","TailpKWs", "PM", "PME","PMKW","PMKWs", 
	  "E&M", "P-val", "MLE", "fE&M", "fP-val", "fMLE")
alphas = c("$\\alpha=5\\%$", "$\\alpha=10\\%$", "$\\alpha=15\\%$")
gammas = c("$\\gamma=5\\%$", "$\\gamma=10\\%$", "$\\gamma=15\\%$")
D = apply(A, 2:6, mean, na.rm = TRUE)
if(FALSE){
for(i in 1:9){
    #quartz()
    alpha = alpha.gamma[i,1]
    gamma = alpha.gamma[i,2]
    pow  = t(D[c(1,5, 2, 4, 12),,i, 1, 1])
    matplot(dfs, pow, type = "b", lty = 1, ylim = c(0,1), pch = 1:5, xlab = "df", ylab = "Power",
	    main = paste("a = ",alpha, "g = ", gamma))
    legend("topright", meths[c(1,5,2,4,12)], lty = 1, pch = 1:5, col = 1:5)
}
}
pdf("nt1-10a.pdf", height = 7, width = 7)
require(lattice)
#NB.  Important that a and g below are factors!!!
B = D[c(1,5, 2, 4, 12),,, 1, 1]
C = aperm(B,c(2,1,3))
D = NULL
for(i in 1:9) 
    D = rbind(D, C[,,i])
dimnames(D)[[2]] = c("OTP", "OPM", "Efron","KWs","EM")
D = data.frame(D)
ag = alpha.gamma
a = factor(rep(ag[,1],each = 5))
g = factor(rep(ag[,2],each = 5))
Data = data.frame(dfs = dfs, D, a = a, g = g)
my.strip <- function(which.given, ..., factor.levels){
    levs <- if(which.given == 2) 
	c(expression(gamma == 0.15), expression(gamma == 0.10), expression(gamma == 0.05))
    else c(expression(alpha == 0.15), expression(alpha == 0.10), expression(alpha == 0.05))
    strip.default(which.given, ..., factor.levels = levs)
}
tp1 = xyplot(OTP + OPM + Efron +KWs + EM ~ dfs|a + g, ylab = "Power",
   par.strip.text = list(cex = .6), auto.key = list(lines = TRUE,columns = 5, cex = .6, points = FALSE),
   data = Data, strip = my.strip, strip.names = TRUE, type = "l", ylim = c(0,.9))
plot(tp1)
dev.off()

