load("MAP-NIX.Rda")
tab0505nix = round(rbind(apply(power[,,4], 2, mean, na.rm = TRUE), apply(mfdr[,,4],2,mean), apply(rejprop[,,4],2,mean)),digits = 4)[,3:4]  # only control for capacity
colnames(tab0505nix)=c("PM-NIX","Tailp-NIX")
rownames(tab0505nix) = c("Power","FDR","SelProp")

tab1005nix = round(rbind(apply(power[,,5], 2, mean, na.rm = TRUE), apply(mfdr[,,5],2,mean), apply(rejprop[,,5],2,mean)),digits = 4)[,3:4]
colnames(tab1005nix)=c("PM-NIX","Tailp-NIX")
rownames(tab1005nix) = c("Power","FDR","SelProp")

tab1505nix = round(rbind(apply(power[,,6], 2, mean, na.rm = TRUE), apply(mfdr[,,6],2,mean), apply(rejprop[,,6],2,mean)),digits = 4)[,3:4]
colnames(tab1505nix)=c("PM-NIX","Tailp-NIX")
rownames(tab1505nix) = c("Power","FDR","SelProp")

tab0510nix = round(rbind(apply(power[,,7], 2, mean, na.rm = TRUE), apply(mfdr[,,7],2,mean,na.rm=TRUE), apply(rejprop[,,7],2,mean,na.rm = TRUE)),digits = 4)[,3:4]
colnames(tab0510nix)=c("PM-NIX","Tailp-NIX")
rownames(tab0510nix) = c("Power","FDR","SelProp")

tab1010nix = round(rbind(apply(power[,,8], 2, mean, na.rm = TRUE), apply(mfdr[,,8],2,mean,na.rm=TRUE), apply(rejprop[,,8],2,mean,na.rm = TRUE)),digits = 4)[,3:4]
colnames(tab1010nix)=c("PM-NIX","Tailp-NIX")
rownames(tab1010nix) = c("Power","FDR","SelProp")

tab1510nix = round(rbind(apply(power[,,9], 2, mean, na.rm = TRUE), apply(mfdr[,,9],2,mean,na.rm=TRUE), apply(rejprop[,,9],2,mean,na.rm = TRUE)),digits = 4)[,3:4]
colnames(tab1510nix)=c("PM-NIX","Tailp-NIX")
rownames(tab1510nix) = c("Power","FDR","SelProp")

tab0501nix = round(rbind(apply(power[,,1], 2, mean, na.rm = TRUE), apply(mfdr[,,1],2,mean), apply(rejprop[,,1],2,mean)),digits = 4)[,3:4]
colnames(tab0501nix)=c("PM-NIX","Tailp-NIX")
rownames(tab0501nix) = c("Power","FDR","SelProp")

tab1001nix = round(rbind(apply(power[,,2], 2, mean, na.rm = TRUE), apply(mfdr[,,2],2,mean), apply(rejprop[,,2],2,mean)),digits = 4)[,3:4]
colnames(tab1001nix)=c("PM-NIX","Tailp-NIX")
rownames(tab1001nix) = c("Power","FDR","SelProp")

tab1501nix = round(rbind(apply(power[,,3], 2, mean, na.rm = TRUE), apply(mfdr[,,3],2,mean), apply(rejprop[,,3],2,mean)),digits = 4)[,3:4]
colnames(tab1501nix)=c("PM-NIX","Tailp-NIX")
rownames(tab1501nix) = c("Power","FDR","SelProp")



load("normal_discrete_panel.Rda")

tab0505 = round(rbind(apply(power[,,4], 2, mean, na.rm = TRUE), apply(mfdr[,,4],2,mean), apply(rejprop[,,4],2,mean)),digits = 4)[,c(1,2,7,8)]  # KWTP and KWPM is under both cap and fdr control, p-value and MLE is under just cap constraint 
colnames(tab0505)=c("PM","Tailp","p-value","MLE")
rownames(tab0505) = c("Power","FDR","SelProp")

tab1005 = round(rbind(apply(power[,,5], 2, mean, na.rm = TRUE), apply(mfdr[,,5],2,mean), apply(rejprop[,,5],2,mean)),digits = 4)[,c(1,2,7,8)]
colnames(tab1005)=c("PM","Tailp","p-value","MLE")
rownames(tab1005) = c("Power","FDR","SelProp")

tab1505 = round(rbind(apply(power[,,6], 2, mean, na.rm = TRUE), apply(mfdr[,,6],2,mean), apply(rejprop[,,6],2,mean)),digits = 4)[,c(1,2,7,8)]
colnames(tab1505)=c("PM","Tailp","p-value","MLE")
rownames(tab1505) = c("Power","FDR","SelProp")

tab0510 = round(rbind(apply(power[,,7], 2, mean, na.rm = TRUE), apply(mfdr[,,7],2,mean,na.rm=TRUE), apply(rejprop[,,7],2,mean,na.rm = TRUE)),digits = 4)[,c(1,2,7,8)]
colnames(tab0510)=c("PM","Tailp","p-value","MLE")
rownames(tab0510) = c("Power","FDR","SelProp")

tab1010 = round(rbind(apply(power[,,8], 2, mean, na.rm = TRUE), apply(mfdr[,,8],2,mean,na.rm=TRUE), apply(rejprop[,,8],2,mean,na.rm = TRUE)),digits = 4)[,c(1,2,7,8)]
colnames(tab1010)=c("PM","Tailp","p-value","MLE")
rownames(tab1010) = c("Power","FDR","SelProp")

tab1510 = round(rbind(apply(power[,,9], 2, mean, na.rm = TRUE), apply(mfdr[,,9],2,mean,na.rm=TRUE), apply(rejprop[,,9],2,mean,na.rm = TRUE)),digits = 4)[,c(1,2,7,8)]
colnames(tab1510)=c("PM","Tailp","p-value","MLE")
rownames(tab1510) = c("Power","FDR","SelProp")

tab0501 = round(rbind(apply(power[,,1], 2, mean, na.rm = TRUE), apply(mfdr[,,1],2,mean), apply(rejprop[,,1],2,mean)),digits = 4)[,c(1,2,7,8)]
colnames(tab0501)=c("PM","Tailp","p-value","MLE")
rownames(tab0501) = c("Power","FDR","SelProp")

tab1001 = round(rbind(apply(power[,,2], 2, mean, na.rm = TRUE), apply(mfdr[,,2],2,mean), apply(rejprop[,,2],2,mean)),digits = 4)[,c(1,2,7,8)]
colnames(tab1001)=c("PM","Tailp","p-value","MLE")
rownames(tab1001) = c("Power","FDR","SelProp")

tab1501 = round(rbind(apply(power[,,3], 2, mean, na.rm = TRUE), apply(mfdr[,,3],2,mean), apply(rejprop[,,3],2,mean)),digits = 4)[,c(1,2,7,8)]
colnames(tab1501)=c("TailP","PM","p-value","MLE")
rownames(tab1501) = c("Power","FDR","SelProp")


T0501 = cbind(tab0501,tab0501nix)
T0505 = cbind(tab0505, tab0505nix)
T0510 = cbind(tab0510, tab0510nix)

#tab10 = cbind(tab1001,tab1001nix, tab1005,tab1005nix, tab1010, tab1010nix)
#tab15 = cbind(tab1501,tab1501nix, tab1505,tab1505nix, tab1510,tab1510nix)

#require(xtable)
#xtable(cbind(t(tab05),t(tab10),t(tab15)),digits = 3)
#xtable(cbind(t(tab0501), t(tab0505), t(tab0510)), digits = 3)

D= cbind(t(T0501), t(T0505), t(T0510))
require(Hmisc)
meths = c("PM","TP","P-value","MLE","PM-NIX","TP-NIX")
alphas = c("Power","FDR","SelProp")
#gammas = c("$\\gamma=5\\%$", "$\\gamma=10\\%$", "$\\gamma=15\\%$")
gammas = c("$\\gamma=1\\%$","$\\gamma=5\\%$", "$\\gamma=10\\%$")
dimnames(D) = list(rep(meths, 1), rep(alphas,3))
cap = "Performance comparison for ranking procedures based on posterior mean,  
posterior tail probability, the P-value and the MLE of $\\theta_i$.  
All results are based on 200 simulation repetitions with n = 50,000 for 
G following the three point discrete distribution and T = 9 or when G is assumed 
to follow a normal-inverse-chi-square distribution. For the first two rows, number reported in the table correspond to performance when both capacity and FDR constraints are in place. For the last four rows, only capacity constraint is in place."
latex(round(D,digits = 3), file = "normal_discrete_panela1.tex", rowlabel = "", cgroup = gammas, caption.loc = "bottom", caption = cap, label = "tab.ndpanel")
