# MAP (Gu, Zaheer, Li, IEEE (2014))
# paper title: multiple population moment estimation: exploiting inter population correlation for efficient moment estimation in analog/mixed-signal validation


# Normal-inverse-chi-squared prior 
# panel data normal model with conjugate prior 

# plalpha is ranking individuals with MAP of theta [posterior mean theta under NIX prior]
# vlalpha is ranking individuals with tail probability of theta >= theta_alpha [under NIX prior] (see contour plot of selection region in normal_discrete_panel.R)

hyperMLE <- function(para, y = y, s = s, t = t){
	# y is sample mean 
	# s is sample variance
	theta0 = para[1]
	kappa0 = para[2]
	nu0 = para[3]
	sig0sq = para[4]
	kappaT = kappa0 + t
	nuT = nu0 + t
	thetaT = (kappa0 * theta0 + t * y)/kappaT
	sigTsq = (nu0 * sig0sq + (t-1) * s + t * kappa0 * (theta0 - y)^2 /(kappa0 + t))/nuT
	-sum(log((gamma(nuT/2) / gamma(nu0/2)) * sqrt(kappa0 / kappaT) *( nu0 * sig0sq)^(nu0/2)/(nuT  * sigTsq)^(nuT/2) /pi^(T/2)))
	}
	
rG = function(n, T, G) {
	r = (T-1)/2
sampler = sample(1:nrow(G$x),n, prob = G$y, replace = TRUE)
x = rnorm(n, G$x[sampler,1], sd = sqrt(G$x[sampler,2]^2/T))
s = sqrt(rgamma(n, shape = r, scale = G$x[sampler,2]^2/r))
list(x = x, s = s, T = T, sampler = sampler)
}

LinearPM = function(x, s, m, cnull, kappa0, theta0){
	(kappa0 * theta0 + m * x)/(kappa0 + m)
	}

Linearvalpha = function(x, s, m, cnull, para){
	# calculate P(theta >= theta_alpha | Y, S) based on NIX prior for (theta, sigma^2)
	# = 1 - F((theta_alpha - thetaT)/sqrt(sigTsq/kappaT)) with F being CDF of t with df = nuT 
	theta0 = para[1]
	kappa0 = para[2]
	nu0 = para[3]
	sig0sq = para[4]
	kappaT = kappa0 + m
	nuT = nu0 + m
	thetaT = (kappa0 * theta0 + m * x)/kappaT
	sigTsq = (nu0 * sig0sq + (m-1) * s + m * kappa0 * (theta0 - x)^2 /(kappa0 + m))/nuT
	vlalpha = 1 - pt((cnull - thetaT)/sqrt(sigTsq/kappaT), df = nuT)
	return(vlalpha) 
	}
	
FDRcut1 = function(c, value, theta, cnull, gamma ){
	# for any thresholding rules: 1(value >= c)
	# calculate trueFDR - FDRcontrol 
	# uniroot will find the cutvalue c given gamma. 
	# only works for tail p rules 
	mean((1-value - gamma)*(value >= c))/mean((value >= c))  
	}
	
FDRcut2 = function(c, value, theta, cnull, gamma){
	mean((value >= c & theta < cnull))/mean(value >= c) - gamma
	}	

set.seed(22)
require(LaplacesDemon)
R = 200
alpha.gamma = expand.grid(c(0.05, 0.1, 0.15), c(0.01, 0.05, 0.1))
alpha.gamma$truecnull = truecnull = rep(c(4.7,3.7,3.7),3)
power = array(NA,c(R,6,nrow(alpha.gamma)))
mfdr  = array(NA,c(R,6,nrow(alpha.gamma)))
rejprop = array(NA,c(R,6,nrow(alpha.gamma)))
FDRcomp = array(NA,c(R,6,nrow(alpha.gamma)))
for (j in 1:nrow(alpha.gamma)){
for (sim in 1:R){
T = 9
n = 50000
r = (T-1)/2
G = list(x = matrix(c(-1, 4, 5, 6,2,4), nrow = 3), y = c(0.85, 0.1, 0.05), sigma = 1)
D = rG(n, T, G)
hyperest = optim(par = c(0, 7, 30, 30), hyperMLE, method = "L-BFGS-B", y = D$x, s = D$s^2, t = rep(T, n))$par

theta = G$x[D$sampler,1]
alpha = alpha.gamma[j,1]
gamma = alpha.gamma[j,2]
cnull = hyperest[1] + sqrt(hyperest[4]/hyperest[2]) * qt(1-alpha, df = hyperest[3])
truecnull = alpha.gamma[j,3]
plalpha = rep(NA,n)
vlalpha = rep(NA,n)
for (i in 1:n){
	plalpha[i] = LinearPM(D$x[i], D$s[i]^2, m = T, cnull = cnull, kappa0 = hyperest[2], theta0 = hyperest[1])
	vlalpha[i] = Linearvalpha(D$x[i], D$s[i]^2, m = T, cnull = truecnull, para = hyperest)
	}
	
Tpml0 = quantile(plalpha, 1-alpha)
Tpml1 = try(uniroot(FDRcut2, interval = c(min(plalpha)+1e-03, max(plalpha)-1e-03), value = plalpha,theta = G$x[D$sampler,1],cnull = cnull, gamma = gamma,extendInt="yes")$root)

TLfdrl0 = quantile(vlalpha,1-alpha)
TLfdrl1 = try(uniroot(FDRcut2, interval = c(min(vlalpha)+1e-03, max(vlalpha)-1e-03), value = vlalpha,theta = G$x[D$sampler,1],cnull = truecnull, gamma = gamma,extendInt="yes")$root)


Pnonnull = mean(theta  >= truecnull) 
trueset = which(theta >= truecnull)

if (inherits(Tpml1, "try-error")){
	powerp = NA
	powerp1 = NA
	powerp2 = NA
	FDRp = NA
	FDRp1 = NA
	FDRp2 = NA
	rejp = NA
	rejp1 = NA
	rejp2=NA
	}else{
		selpl = which(plalpha > max(Tpml0,Tpml1))
		selpl1 = which(plalpha > Tpml0)
		selpl2 = which(plalpha > Tpml1)
		powerp = length(intersect(trueset, selpl))/n/Pnonnull
		powerp1 = length(intersect(trueset, selpl1))/n/Pnonnull
		powerp2 = length(intersect(trueset, selpl2))/n/Pnonnull
		FDRp = length(setdiff(selpl,trueset))/length(selpl)
		FDRp1 = length(setdiff(selpl1,trueset))/length(selpl1)
		FDRp2 = length(setdiff(selpl2, trueset))/length(selpl2)
		rejp = length(selpl)/n
		rejp1 = length(selpl1)/n
		rejp2 = length(selpl2)/n
	}

if (inherits(TLfdrl1, "try-error")){
	powerv = NA
	powerv1 = NA
	powerv2 = NA
	FDRv = NA
	FDRv1 = NA
	FDRv2 = NA
	rejv = NA
	rejv1 = NA
	rejv2 = NA
	}else{
		selvl = which(vlalpha > max(TLfdrl0,TLfdrl1))
		selvl1 = which(vlalpha > TLfdrl0)
		selvl2 = which(vlalpha > TLfdrl1)
		powerv = length(intersect(trueset, selvl))/n/Pnonnull
		powerv1 = length(intersect(trueset, selvl1))/n/Pnonnull
		powerv2 = length(intersect(trueset, selvl2))/n/Pnonnull
		FDRv = length(setdiff(selvl,trueset))/length(selvl)
		FDRv1 = length(setdiff(selvl1,trueset))/length(selvl1)
		FDRv2 = length(setdiff(selvl2, trueset))/length(selvl2)
		rejv = length(selvl)/n
		rejv1 = length(selvl1)/n
		rejv2 = length(selvl2)/n
	}

power[sim,,j] = c(powerp, powerv, powerp1, powerv1, powerp2, powerv2)
mfdr[sim,,j] = c(FDRp, FDRv, FDRp1, FDRv1,FDRp2, FDRv2)
rejprop[sim,,j] = c(rejp, rejv, rejp1,rejv1, rejp2, rejv2)
print(c(j,sim))
}
}

