# An attempt to re-organize the threshold code a bit.
# Throughout G denotes the mixing density for the Gaussian sequence model
# G is encoded as a GLmix object, e.g.
# normal - normal model 
# compare selection frontier for Lfdr and posterior mean rules, under capacity and/or FDR constraint

require(REBayes)

  # So posterior means, and so forth can be computed with predict, e.g.

PM = function(x, G, s, cnull =3) predict(G, x, newsigma = s)

# Local fdr needs a cutoff,

Lfdr = function(x, G, s, cnull){
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    if (sum(A)==0){
    	1}else{
    1 - c((A %*% (fv * (v < cnull)))/(A %*% fv))
    }
}
# Some generic code for computing inverses with uniroot
    # Useage Examples:
    # x0 = Finv(2, F = qnorm, sd = 2) 
    # x1 = mapply(Finv, 1:5/10, MoreArgs = list(F = qnorm, sd = 2)) 

Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes")$root 

# Generic thresholding functions

Thresh0 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(nu, fs)
    }   
Thresh1 = function(lam, Fun, G, s, fs, domain, cnull ){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    cnu = rep(NA,ns)
    #if(cnull == 4) browser()
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
	cnu[j]  = sum(G$y * (G$x < cnull) * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(cnu, fs)/crossprod(nu, fs)
    }   
    
    # DGP : normal normal model 
     G = list(x = seq(-3,3,length = 200), y = c(dnorm(seq(-3,3,length = 200))/sum(dnorm(seq(-3,3,length=200)))), sigma = 1)
    class(G) = "GLmix"
    rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
    s = seq(0.5,1,length = 200)  # sigma values
    x = rG(200, G, s)
    # scaled beta (density of s monotone increasing on the support)
    #fs = dbeta(s/max(s), 6,1)/sum(dbeta(s/max(s), 6,1))  
    fs = rep(1/length(s), length(s))
    postmean = predict(G, x, newsigma = s)




# Now try plotting
alpha = 0.05
gamma = 0.2
    Tpm0 = Finv(alpha, Thresh0, Fun = PM, interval = c(0.1,2), G = G, s = s, fs = fs, domain = c(-20,20), cnull=qnorm(1-alpha))
    cpm0 = rep(NA, length(s))
    for(i in 1:length(s))
	cpm0[i] = Finv(Tpm0, PM, interval = c(-2,7), G = G, s = s[i], cnull = qnorm(1-alpha)) 
    Tpm1 = Finv(gamma, Thresh1, Fun = PM, interval = c(0.1,2.4),G = G, s = s, fs = fs, domain = c(-20,20), cnull=qnorm(1-alpha))
    cpm1 = rep(NA, length(s))
    for(i in 1:length(s))
	cpm1[i] = Finv(Tpm1, PM, interval = c(-20,20), G = G, s = s[i], cnull = qnorm(1-alpha)) 

    TLfdr0 = Finv(alpha, Thresh0, c(0.01, 0.9), Fun = Lfdr, G = G, s = s, 
		  fs = fs, domain = c(-20, 20), cnull=qnorm(1-alpha))
    cLfdr0 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr0[i] = Finv(TLfdr0, Lfdr, interval = c(-20,20), G = G, s = s[i], cnull = qnorm(1-alpha)) 
    TLfdr1 = Finv(gamma, Thresh1, c(0.1, 0.9), Fun = Lfdr, G = G, s = s, fs = fs, domain = c(-20, 20), cnull = qnorm(1-alpha))
    cLfdr1 = rep(NA, length(s))
    for(i in 1:length(s))
	cLfdr1[i] = Finv(TLfdr1, Lfdr, interval = c(-20,20), G = G, s = s[i],cnull = qnorm(1-alpha)) 



# sampling 
set.seed(1)
n = 10000
ss = runif(n, 0.5, 1)  # sigma values
mu = sample(G$x, n, replace=TRUE, prob = G$y)
x = mu + rnorm(n, mean = 0, sd = ss)

A = dnorm(outer(x, G$x, "-"), sd = ss)
ghat = A%*%G$y
tghat = A%*%(G$y * (G$x > qnorm(1-alpha)))
tailp = tghat/ghat
pm = A%*%(G$y * G$x)/ghat

# plot reject region for two criteria and for a realized sample

pdf("nn2.pdf", width = 9, height = 4)
par(mfrow=c(1,3))

criteria.cap = list(Tailp = which(tailp >= TLfdr0), Tweedie = which(pm > Tpm0))
setallc = intersect(criteria.cap[[1]], criteria.cap[[2]])
set1diffc = setdiff(criteria.cap[[1]],setallc)
set2diffc = setdiff(criteria.cap[[2]], setallc)
ylim1 = range(c(x[setallc], x[set1diffc],x[set2diffc]))
plot(s, cpm0, type="l",ylim = ylim1, ylab = "Threshold", 
     xlab = expression(sigma), main = "Selection Boundaries")
lines(s, cLfdr0,lty=2)
lines(s,cpm1,col=2)
lines(s,cLfdr1,col=2,lty=2)
legend("topleft", c("Lfdr-C", "PM-C", "Lfdr-FDR","PM-FDR"), col = c(1,1,2,2), lty = c(2,1,2,1))
plot(ss[setallc], x[setallc] , ylim =ylim1, col = "grey", 
     xlim = range(c(ss[setallc], ss[set1diffc], ss[set2diffc])), 
     main = "Capacity constraint",   ylab = "y", xlab = expression(sigma))
points(ss[set1diffc], x[set1diffc], col = 2, pch = 3)
points(ss[set2diffc], x[set2diffc], col = 3 , pch = 4)
legend("topleft", c("All agreed", "Tailp extra", "PM extra"), col = c(1, 2, 3), pch = c(1, 3, 4))

criteria.fdr = list(Tailp = which(tailp >= TLfdr1), Tweedie = which(pm > Tpm1))
setallr = intersect(criteria.fdr[[1]], criteria.fdr[[2]])
set1diffr = setdiff(criteria.fdr[[1]],setallr)
set2diffr = setdiff(criteria.fdr[[2]], setallr)

plot(ss[setallr], x[setallr], ylim =ylim1, col = "grey",
     xlim = range(c(ss[setallc], ss[set1diffc], ss[set2diffc])), 
     main = "FDR constraint",  ylab = "y", xlab = expression(sigma))
points(ss[set1diffr], x[set1diffr], col = 2,  pch = 3)
points(ss[set2diffr], x[set2diffr], col = 3,  pch = 4)
legend("topleft", c("All agreed", "Tailp extra", "PM extra"), col = c(1, 2, 3), pch = c(1, 3, 4))

dev.off()    

Thresh1(lam = TLfdr0, Fun = Lfdr, G, s,fs,domain = c(-20,20), cnull = qnorm(1-alpha))   #FDR level with just capacity constraint at alpha. 
Thresh1(lam = Tpm0, Fun = PM, G, s,fs,domain = c(-20,20), cnull = qnorm(1-alpha))   #FDR level with just capacity constraint at alpha. 
