
# Conditional tail probability function
valpha = function(y, s, G, Talpha = 5)
	sum(G$y * dnorm(y, G$x, s) * (G$x >= Talpha))/sum(G$y * dnorm(y, G$x, s))
Valpha = function(y,s, G, Talpha) {
    V = matrix(NA,length(y),1)
    for(i in 1:length(y)){
	    V[i] = valpha(y[i],s[i],G,Talpha)
	}
    V
}
rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
Ginv = function(G) stepfun(cumsum(G$y), c(G$x, G$x[length(G$x)]))

# Some experiments to explore "crossing"
require(rvalues)
require(REBayes)
# Comparison of npmle in the rvalues package with REBayes
if(FALSE){ # Test of npmle function from rvalues
    data(hiv)
    #f1 = npmle(hiv, family = tdist(df=6), maxiter = 25)
    plot(f1$support, f1$mix.prop, type = "l")
    f0 = TLmix(hiv$estimates/hiv$std.err, df = 6)
    plot(f0)
}
Lfdr = function(x, G, s, cnull ){
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    if (sum(A)==0){
    	1}else{
    1 - c((A %*% (fv * (v < cnull)))/(A %*% fv))
    }
}
Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes")$root 
Thresh0 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(nu, fs)
    }   
G = list(x = c(-1, 2, 5), y = c(0.85, 0.1, 0.05), sigma = 1)


class(G) = "GLmix"
rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
s = seq(0.5,4,length = 200)  # sigma values
x = rG(200, G, s)
# scaled beta (density of s monotone increasing on the support)
#fs = dbeta(s/max(s), 6,1)/sum(dbeta(s/max(s), 6,1))  
fs = rep(1/length(s), length(s))
alphas = c(4,5,6, 8)/100
cLfdr0 = matrix(NA, length(s), length(alphas))
for(j in 1:length(alphas)){
    TLfdr0 = Finv(alphas[j], Thresh0, c(0.01, 0.99), Fun = Lfdr, G = G, s = s,
                  fs = fs, domain = c(-2, 7), cnull=Ginv(G)(1-alphas[j])-0.01)
    for(i in 1:length(s))
	cLfdr0[i,j] = Finv(TLfdr0, Lfdr, interval = c(-2,7), G = G, s = s[i], cnull = Ginv(G)(1-alphas[j])-0.01)
}
pdf(file = "Ceg12.pdf", height = 6, width = 9)
par(mfrow = c(1,2))
matplot(s, cLfdr0, type = "l", xlab = expression(sigma),ylab = "y threshhold",  
	lwd = 2, lty = 1)
leg = expression(alpha == 0.04, alpha == 0.05, alpha == 0.06, alpha == 0.08)
k = 30*(1:6)
for(i in 1:4)
    points(s[k], cLfdr0[k,i], pch =  i, col = i)
legend("topleft", leg, lwd = 2, col = 1:4, pch = 1:4, lty = 1)


# Conditional tail probability function
valpha = function(y, s, G, Talpha = 5)
	sum(G$y * dnorm(y, G$x, s) * (G$x >= Talpha))/sum(G$y * dnorm(y, G$x, s))
Valpha = function(y,s, G, Talpha) {
    V = matrix(NA,length(y),1)
    for(i in 1:length(y)){
	    V[i] = valpha(y[i],s[i],G,Talpha)
	}
    V
}
rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
Ginv = function(G) stepfun(cumsum(G$y), c(G$x, G$x[length(G$x)]))

# Some experiments to explore "crossing"
require(rvalues)
require(REBayes)
# Comparison of npmle in the rvalues package with REBayes
if(FALSE){ # Test of npmle function from rvalues
    data(hiv)
    #f1 = npmle(hiv, family = tdist(df=6), maxiter = 25)
    plot(f1$support, f1$mix.prop, type = "l")
    f0 = TLmix(hiv$estimates/hiv$std.err, df = 6)
    plot(f0)
}
PM = function(x, G, s, cnull = 3) predict(G, x, newsigma = s)
Lfdr = function(x, G, s, cnull ){
    v = G$x
    fv = G$y
    A = dnorm(outer(x, v, "-"), sd = s)
    if (sum(A)==0){
    	1}else{
    1 - c((A %*% (fv * (v < cnull)))/(A %*% fv))
    }
}
Finv = function(y, F, interval = c(0,1), ...) 
    uniroot(function(x) F(x, ...) - y, interval, extendInt = "yes")$root 
Thresh0 = function(lam, Fun, G, s, fs, domain, cnull){
    # find value such that Fun criterion is met
    ns = length(s)
    nu = rep(NA,ns)
    for (j in 1:ns){
        cut = Finv(lam, Fun, interval = domain, G = G, s = s[j], cnull)
        nu[j]  = sum(G$y * (1 - pnorm(cut - G$x, sd = s[j])))
        }
    crossprod(nu, fs)
    }   
G = list(x = c(-1, 2, 5), y = c(0.85, 0.1, 0.05), sigma = 1)


class(G) = "GLmix"
rG = function(n, G, s) rnorm(n,sample(G$x, prob = G$y, replace = TRUE),s)
s = seq(0.5,4,length = 200)  # sigma values
x = rG(200, G, s)
# scaled beta (density of s monotone increasing on the support)
#fs = dbeta(s/max(s), 6,1)/sum(dbeta(s/max(s), 6,1))  
fs = rep(1/length(s), length(s))
alphas = c(4,5,6, 8)/100
cpm0 = matrix(NA, length(s), length(alphas))
for(j in 1:length(alphas)){
    Tpm0 = Finv(alphas[j], Thresh0, c(2,4), Fun = PM, G = G, s = s,
                  fs = fs, domain = c(-2, 7), cnull=4)
    for(i in 1:length(s))
	cpm0[i,j] = Finv(Tpm0, PM, interval = c(-2,7), G = G, s = s[i], cnull = 4)
}
matplot(s, cpm0, type = "l", xlab = expression(sigma),ylab = "y threshhold",  
	lwd = 2, lty = 1)
leg = expression(alpha == 0.04, alpha == 0.05, alpha == 0.06, alpha == 0.08)
k = 30*(1:6)
for(i in 1:4)
    points(s[k], cpm0[k,i], pch =  i, col = i)
legend("topleft", leg, lwd = 2, col = 1:4, pch = 1:4, lty = 1)
dev.off()

