# Demonstration of Testing for homogeneity of Poisson mixture. 
# H0: homogeneous Poisson mean parameter 
# H1: Two component discrete distribution for the Poisson mean parameter. (Chen I Example, c.f. Chen (1995))


require(REBayes)

set.seed(1200)



Calpha<-function(x)  (sqrt(length(x)/2) * max(0,(var(x)/mean(x) - 1)))^2   # C(alpha) test, c.f. Gu (2016)

logLik0 <- function(x) {
# computes the log likelihood for the null model 	
sum(dpois(x,mean(x),log = TRUE))
}

n <- 1000
hs <- seq(0,0.22,by = 0.02)  # for a grid of $h$ values of Chen I Example 
alpha <- 2/3
R <- 1000   # Number of simulation repetitions
B = 1500	# Number of bootstrap sample repetition for critical value
A <- array(0,c(5,length(hs),R))


for (j in 1:length(hs)){
h = hs[j]
for (i in 1:R){
a<-sample(c(-h/alpha,h/(1-alpha)),n, prob = c(alpha,1-alpha), replace = TRUE)
x <- rpois(n,2*exp(a))
Lb <- rep(0,B)
for (b in 1:B){
y <- rpois(n,mean(x))
Lb[b] <- 2*(Pmix(y,control = list(iparam = list(num_threads = 1)))$logLik - logLik0(y))
}
A[1,j,i] <- quantile(Lb,0.9)  # 90% quantile bootstrap cv.	
A[2,j,i] <- quantile(Lb,0.95) # 95% quantile bootstrap cv. 
A[3,j,i] <- quantile(Lb,0.99) # 99% quantile bootstrap cv. 
A[4,j,i] <- 2*(Pmix(x,control = list(iparam = list(num_threads = 1)))$logLik- logLik0(x)) # NPMLE Likelihood Ratio Test stat. 
A[5,j,i] <- Calpha(x)   # C(alpha) test statistics 
}
}

