# Computation of Bivariate Bayes rule (E(\alpha | mean, variance))
# Two ways (1) E(\alpha|mean) (2) E(\alpha|mean,variance)
# The exercise here shows the two can be very different
# We take the best fit model from MP_Profile_twofactor (profile on AR coefficient rho)
# We sample pairs (alpha, theta) from the KW mixing distribution H(alpha, theta)
# Based on the samples n pairs, we generate Gaussian longitudinal data 
# Then we compute from these Gaussian data the pair of sample mean and sample variance
# We compute Bayes rule as described above in line 2
# Coupld of ways to proceed: (1) Contour plot illustrate when both sample mean and sample variance changes, how the posterior mean for alpha looks (2) We can also fix sample variance, and see how posterior mean of alpha changes when sample mean changes. (3) We can also ignore sample variance and compute E(alpha|sample mean) and see how it changes with sample mean. 
# In bayesrule.R source code, delta3 function computes proposal (1); it can also be used to compute proposal (2) when we fix the feeded in sample variance; delta4 function computes proposal (3). 




require(REBayes)
require(tensor) # For one nasty array multiplication!
source("bayesrules.R")
#set.seed(19)
set.seed(197)
### Bivariates
require(REBayes)
require(foreign)

source("plot.WGLVmix.R")
source("bayesrules.R")
load("MP_Profile_twofactor.Rda")
best <- which.max(LogLik)
f$fuv <- fmix[,best]
f$v <- fv[,best]
f$u <- fu[,best]
f$rho <- rhos[best]

buv  <- expand.grid(theta = f$v, alpha = f$u)
nuv  <- nrow(buv)
F = t(as.vector(f$fuv/sum(f$fuv)))
F <- pmax(F,0)
rp <- function(n) 

apply(F, 1, function(p) {buv[sample(1:nuv, n, prob = p, replace = TRUE),]})  # KW mixing distribution to be sampled from


n <- 3000
m <- 15

av <- rp(n)[[1]]
al = av$alpha  # alpha parameter 
vl = av$theta  # theta parameter
x <- rnorm(m*n, rep(al, each = m), sd = rep(sqrt(vl), each = m))  # Gaussian longitudinal data 
id <- rep(1:n, each = m)

a <- tapply(x,id,"mean")
s <- tapply(x,id,"var")
ya <- seq(min(a) - 0.1, max(a)+0.1, length = 200)  # the new data for sample mean
yv <- seq(0.0001, max(s), length = 200) # the new data for sample variance


# Proposal (1) 
D = matrix(0, length(ya),length(yv))  # both ya and yv varies
for (i in 1:length(ya)){
for (j in 1:length(yv)){
D[i,j] = delta3(ya[i],yv[j],f,m)
}
}

pdf("tweedie_contour.pdf")
#levels = c(-30:21/30)
#levels = c(-1,-0.9,-0.8,-0.7,-0.6,-0.5,-.4,-.3,-0.285,-0.2,-0.1,0,1:7/10)

levels = c(-10:-2/10,-0.18,-0.16,-0.14,-0.12,-1:7/10)
contour(ya,yv,D, levels = levels,method = "flattest", xlab = expression(bar(y)), ylab = "s")
#rug(al, col = 3)
#rug(levels,col=4,ticksize = 0.01)
points(a,s,cex = .3,col = "grey")

dev.off()


## Proposal (2) 
pdf("tweedie_var.pdf")
D = matrix(0, length(ya),1)
for (i in 1:length(ya)){
D[i,1] = delta3(ya[i],yv[1],f,m)
}
plot(ya,D,type="n",ylim=c(-1,1), lwd = 2,xlab = expression(bar(y)),
     ylab = expression(hat(alpha)))
plate = c(10,20,80)
ltys <- c(2,1,4)
for (k in 1:length(plate)){
D = matrix(0, length(ya),1)
for (i in 1:length(ya)){
D[i,1] = delta3(ya[i],yv[plate[k]],f,m)
}
lines(ya,D,col = ltys[k], lty = ltys[k],lwd = 2)
}
abline(c(0,1))
legend("topleft",c( paste("s=",round(yv[plate[1]],digits = 3),sep=""),
		   paste("s=",round(yv[plate[2]],digits = 3),sep=""),
		   paste("s=",round(yv[plate[3]],digits = 3),sep="")),
       col = c(2,1,4), lty = c(2,1,4), lwd = 2)
dev.off()
