# Test code for new predict function


plot.WGLVmix <- function(ids, fit, T0 = 9, T1 = 25, pn = 50, pm = 50, 
	     probs = 1:19/20, hex = FALSE, Uband = FALSE, data = psid, main = NULL){
    require(fanplot)
    # Make newdata
    y <- data$ystand
    id <- data$id
    age <- data$age
    rho <- fit$rho
    dy <- unlist(tapply(y,id,pardiff,rho = rho))
    nd <- cbind(dy = dy, id = id, y = y,age = age )[id %in% ids,]
    nd <- data.frame(nd)
    nd <- nd[!is.na(nd$dy),]

    for(i in 1:length(ids)){
	ndi <- nd[nd$id == ids[i],]
	ndi0 <- ndi[1:T0,]
	if(T0 > nrow(ndi)) stop("Too few observations: reduce T0?")
	if(hex){ # This option needs further work!
	    require(hexbin)
	    require(lattice)
	    rpost <- predict.WGLVmix(fit, ndi)
	    n <- 10000
	    Y <- rpost(n)[[1]]
	    du <- diff(f$u)[1]
	    dv <- diff(f$v)[1]
	    G <- Y + cbind(runif(n,0,dv), runif(n,0,du))
	    H <- hexbin(G$alpha, G$theta, xbins = 60)
	    plot(H,colramp = function(n) LinGray(n,92,30), legend = FALSE,
		xlab = expression(hat(alpha)),ylab = expression(hat(theta)))
	    }
	else {
	   rpost <- predict.WGLVmix(fit, ndi0)
	    G <- rpost(pn)[[1]]
	    Y <- matrix(0, T1, pn * pm)
	    for(j in 1:pn){
		cols <- seq((j-1)*pm + 1, pm*j)
		U <- matrix(rnorm(pm * T1, mean = G[j,2], sd = sqrt(G[j,1])), pm, T1)
		Y[,cols] <- apply(U, 1, function(u) 
			filter(u, rho, method = "recursive", init = ndi$y[T0]))
	    }
	    QY <- apply(Y,1, function(y) quantile(y, probs = 1:19/20, na.rm = TRUE))
	    if(Uband) {
		coverage <- function(a, p, V, L, M, U){
		    below <- (V < outer(L - a * (M - L), rep(1, ncol(V))))  
		    above <- (V > outer(U + a * (U - M), rep(1, ncol(V))))
		    out <- below | above
		    1 - sum(apply(out, 2, any))/ncol(V) - p
		}
		
		UBand <- function(V, Q, upperBound = 20){
		    # V is a T by M simulated sample paths
		    # Q is a np by T matrix of quantile paths of pointwise bands
		    # Assumes that probs are symmetric about 0.5 and np is odd
		    # upperBound for root finding may require some adjustment
		    ahat <- rep(0, nrow(Q))
		    np <- length(probs)
		    for(i in 1:((np -1)/2)){
			L <- Q[i,]
			M <- Q[(np +1)/2,]
			U <- Q[np + 1 - i,]
			p <- probs[np + 1 - i] - probs[i]
			ahat <- uniroot(coverage, c(0,upperBound), p=p, V=V, L=L, M=M, U=U)$root
			Q[i,] <- L - ahat * (M - L)
			Q[np + 1 - i,] <- U + ahat * (U - M)
		    }
		    Q
		}
		QY <- UBand(Y, QY)
	    }
	    Qplot(ndi$age, ndi$y, ndi$age[T0] + 1, ndi$y[T0], probs, QY)
	    if(!length(main))
	    	 title(paste("PSID ID Number ", ids[i]))
	    else 
		title(main)
	    }
	}
}


predict.WGLVmix <- function(object, newdata, Loss = 2, ...) {
    # Given a fitted Gaussian Location Scale Mixture predict for the paths {y, id, w}
    #	object is a fitted WGLVmix object
    #	newdata  the paths at which predictions are desired
    #   Loss is the p of the Lp loss function
    # So far,  only returned object is rp  a random generator for the posterior 

    y <- newdata$dy
    id <- newdata$id
    if(!length(newdata$w)) w <- rep(1,length(y))
    u <- object$u
    v <- object$v
    pu <- length(u)
    pv <- length(v)
    fuv <- object$fuv

    wsum <- tapply(w, id, "sum")
    t <- tapply(w * y, id, "sum")/wsum
    m <- tapply(y, id, "length")
    r <- (m - 1)/2
    s <- (tapply(w * y^2, id, "sum") - t^2 * wsum)/(m - 1)
    n <- length(s)
    du <- diff(u)
    du <- c(du[1],du)
    dv <- diff(v)
    dv <- c(dv[1],dv)
    
    R <- outer(r*s,v,"/")  
    sgamma <- outer(s * gamma(r),rep(1,pv))
    r <- outer((m - 1)/2, rep(1,pv))
    Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
    Au <- dnorm(outer(outer(t, u, "-") * outer(sqrt(wsum),rep(1,pu)), sqrt(v), "/"))
    Au <- Au/outer(outer(1/sqrt(wsum),rep(1,pu)),sqrt(v))
    Au <- aperm(Au,c(1,3,2)) # permute Au indices so that they are aligned with those of Av
    A <- matrix(Av * Au, n, pu * pv) * outer(rep(1,n),fuv)
    A <- pmax(A,0)
    buv  <- expand.grid(theta = v, alpha = u)
    nuv  <- nrow(buv)
    A <- A/apply(A, 1, sum)
    rp <- function(n) 
	apply(A, 1, function(p) {buv[sample(1:nuv, n, prob = p, replace = TRUE),]})
    rp
}


Qplot <- function(x, y, x0, y0, p, Q) { # default fan plot 
    plot(x, y, type = "l", lwd = 2, xlab = "Age", ylim = c(-2.5,2.5))
     #xlim = c(y0 - 5, y0 + 3), ylim = c(-2, 7), 
     #xaxt = "n", yaxt = "n", ylab="")


    rect(x0 - 1, par("usr")[3] - 1, x[length(x)] + 5 , par("usr")[4] + 1, 
	border = "gray95", col = "gray95")

    fan(data = Q, data.type = "values", probs = p, 
	start = x0, frequency = 1, anchor = y0, 
	fan.col = colorRampPalette(c("tomato", "gray90")),  
	ln = NULL, rlab = NULL)
    lines(x,y, col = "black", lwd = 2)
}
