# Initial Four Panel Figure   for exv3 example
load("exv3.Rda")
pdf(file = "fig1exv3.pdf", height = 4, width = 12)
par(mfrow = c(1,4))

# Panel 1 -- fu plot
plot(f$u,f$fu,type ="l", xlab = expression(mu), ylab = expression(f(mu)), 
col = 2, main = "Mean Mixing Distribution")
segments(c(-h, 2*h, 6*h),c(0,0),c(-h,2*h, 6*h), c(10,10,10),lwd = 1.3, col = "blue")

# Panel 2 -- fv plot
plot(f$v,f$fv,type ="l", xlab = expression(theta),ylab = expression(f(theta)),  
col = 2, main = "Variance Mixing Distribution")
segments(1+c(-h,2*h, 6*h),c(0,0),1+c(-h,2*h, 6*h), c(10,10,10),lwd = 1.3, col = "blue")

# Panel 3 -- Mixture densities
hist(a,35, freq = FALSE, col = gray(.9), xlab = expression(mu), ylab = expression(g(mu)), 
	main = "Mixture Distribution")
lines(ya, ghat, col = 2) 
lines(ya, gtrue(ya,h), col = "blue")

# Panel 4 -- Bayes Rules
plot(ya, d1hat, ylab = expression(delta (x)), xlab = "x", col = 2, 
	type = "l", main = "Bayes Rule") #full likelihood prediction

lines(ya,d1true, col = "blue")
#lines(ya,d1hat,col=3,lwd = 2)   #partial  likelihood prediction
abline(c(0,1),col = "gray")

dev.off() 
