# Modified exv2.R 
# Use T-Gamma estimation strategy but full likelihood (Normal-Gamma) for prediction and evaluation.
# DGP with 3 mass points for both a and v.
require(REBayes)
require(tensor) # For one nasty array multiplication!
source("bayesrules.R")
#set.seed(19)
set.seed(197)
h <- 0.5
n <- 800
m <- 11

# True mixture density of y is a mixture of 9 Gaussian's 
dmnorm <- function(x, mu, sigma2, m = 11) {
	sigma <- sqrt(sigma2/m)
	dnorm((x - mu)/sigma)/sigma
	}
gtrue <- function(y,h) {
	(dmnorm(y,-h,1-h) + dmnorm(y,-h,1+2*h) +  dmnorm(y,-h,1+6*h) +
	dmnorm(y,2*h,1-h) + dmnorm(y,2*h,1+2*h) + dmnorm(y,2*h,1+6*h) + 
	dmnorm(y,6*h,1-h) + dmnorm(y,6*h,1+2*h) + dmnorm(y,6*h,1+6*h))/9
	}

a <- sample(c(-h,2*h,6*h),n,prob = c(1/3,1/3,1/3),replace = TRUE)
v <- sample(1 + c(-h, 2*h, 6*h), n, prob = c(1/3,1/3,1/3),replace = TRUE)

x <- rnorm(m*n, rep(a, each = m), sd = rep(sqrt(v), each = m))
id <- rep(1:n, each = m)
f <- TLVmix(x,id, rtol = 1e-10, verb = 5, pu = 300, pv = 400)

a <- tapply(x,id,"mean")
s <- tapply(x,id,"var")
ya <- seq(min(a) - 1, max(a)+1, length = 500)
yv <- seq(0.1, max(s)+1, length = 500)
truef <- list(u=c(-h,2*h,6*h),fu = c(1,1,1)/3,v=c(1-h,1+2*h,1+6*h),fv=c(1,1,1)/3)

ghat <- gahat(ya,yv,f,m)
d1hat <- delta1(ya,yv,f,m)
d1true <- delta1(ya,yv,truef,m)
d2hat <- delta2(ya,yv,f,m)
d2true <- delta2(ya,yv,truef,m)
D <- delta2(ya,yv,f,m, outer = TRUE)
save.image("exv3.Rda")
