# The Gaussian location scale example with Student t estimation scheme

require(REBayes)
require(tensor) # For one nasty array multiplication!
set.seed(19)
pdf(file = "exv2a.pdf", height = 4, width = 12)
#quartz(height = 4, width = 12)
#X11(height = 4, width = 9)
par(mfrow = c(1,4))
h <- 0.5
n <- 800
m <- 11
a <- sample(c(-h, 2*h), n, prob = c(2/3,1/3), replace = TRUE)
v <- sample(1 + c(-h, 2*h), n, prob = c(2/3,1/3), replace = TRUE)
x <- rnorm(m*n, rep(a, each = m), sd = rep(sqrt(v), each = m))
id <- rep(1:n, each = m)
f <- TLVmix(x,id, rtol = 1e-10, verb = 5)
plot(f$u,f$fu,type ="l", xlab = expression(mu), ylab = expression(f(mu)), 
	col = 2, main = "Mean Mixing Distribution")
segments(c(-h,2*h),c(0,0),c(-h,2*h), c(50,25),lwd = 1.3, col = "blue")
plot(f$v,f$fv,type ="l", xlab = expression(theta),ylab = expression(f(theta)),  
	col = 2, main = "Variance Mixing Distribution")
segments(1+c(-h,2*h),c(0,0),1+c(-h,2*h), c(15,7.5),lwd = 1.3, col = "blue")


# Plot 3 of the Mixture densities
s <- tapply(x,id,"var")
yv <- seq(0.1, max(s)+3, length = 500)
a <- tapply(x,id,"mean")
ya <- seq(min(a) - 1, max(a)+1, length = 500)
ghat <- function(ya,yv,f,m){ 
	#This is ugly, perhaps it can be simplified at some later point
	pu <- length(f$u)
	pv <- length(f$v)
	pya <- length(ya)
	pyv <- length(yv)
	m <- rep(m, pyv)
	r <- (m-1)/2
	R <- outer(r*yv,f$v,"/")
	K <- outer(gamma(r)/r,f$v)
	r <- outer(r,rep(1,pv))
	gv <- c((exp(-R)*R^(r-1)/K) %*% f$fv * diff(f$v)[1])
	A <- dnorm(outer(outer(ya, f$u, "-") * 
		outer(sqrt(m),rep(1,pu)), sqrt(yv), "/"))
	A <- A/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(yv))
	B <- tensor(A, gv, 3,1)
	ga <- B %*% f$fu * diff(f$u)[1] 
	gb <- (B %*% (f$u * f$fu * diff(f$u)[1])) /ga
	ga = ga/sum(ga*diff(ya)[1])
	list(ga = ga, gb = gb)
	}
hist(a,35, freq = FALSE, xlab = expression(mu), ylab = expression(g(mu)), 
	main = "Mixture Distribution")
G <- ghat(ya,yv,f,m)
ga <- G$ga
gb <- G$gb
lines(ya, ga, col = 2) 

# True mixture density of y is a mixture of 4 Gaussian's 
d4norm <- function(x, mu, sigma2, m = 11) {
	sigma <- sqrt(sigma2/(m-1))
	dnorm((x - mu)/sigma)/sigma
	}
gtrue <- function(y,h) (4*d4norm(y,-h,1-h) + 2*d4norm(y,-h,1+2*h) + 
		2*d4norm(y,2*h,1-h) + d4norm(y,2*h,1+2*h))/9
lines(ya, gtrue(ya,h), col = "blue")

# Plot 3 of the Bayes Rules
plot(ya, gb, ylab = expression(delta (x)), 
	xlab = "x", col = 2, type = "l", main = "Bayes Rule")
delta <- function(ya,yv,f,m){ 
	pu <- length(f$u)
	pv <- length(f$v)
	pya <- length(ya)
	pyv <- length(yv)
	m <- rep(m, pyv)
	r <- (m-1)/2
	R <- outer(r*yv,f$v,"/")
	K <- outer(gamma(r)/r,f$v)
	r <- outer(r,rep(1,pv))
	gv <- c((exp(-R)*R^(r-1)/K) %*% f$fv)
	A <- dnorm(outer(outer(ya, f$u, "-") * 
		outer(sqrt(m),rep(1,pu)), sqrt(yv), "/"))
	A <- A/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(yv))
	B <- tensor(A, gv, 3,1)
	ga <- B %*% f$fu 
	gb <- (B %*% (f$u * f$fu)) /ga
	ga = ga/sum(ga*diff(ya)[1])
	list(ga = ga, gb = gb)
	}
truef <- list(u = c(-h,2*h),fu = c(2,1)/3,v = c(2-h, 2 + 2*h), fv = c(2,1)/3)
lines(ya,delta(ya, yv, truef, m)$gb, col = "blue")
dev.off()


delta2 <- function(a,v,f,m){ #Bivariate Version of Bayes Rule
	pu <- length(f$u)
	pv <- length(f$v)
	M <- rep(m, length(v))
	r <- (M-1)/2
	R <- outer(r*v,f$v,"/")
	K <- outer(gamma(r)/r,f$v)
	r <- outer(r,rep(1,pv))
	gv <- c((exp(-R)*R^(r-1)/K) %*% f$fv)
	A <- dt(outer(outer(a, f$u, "-") * 
		outer(sqrt(M),rep(1,pu)), sqrt(v), "/"),m-1)
	A <- A/outer(outer(1/sqrt(M),rep(1,pu)),sqrt(v))
	B <- A * gv
	tensor(B, (f$u * f$fu), 2,1)/tensor(B, f$fu, 2,1)
	}
B <- delta2(ya,yv,f,m)
pdf("exv2b.pdf",height = 6, width = 6)
levels = c(-.55, -.5, -.4, -.3, -.1, 0, .2, .5, .8, 1)
contour(ya,yv,B,levels = levels, xlab = expression(mu), ylab = expression(sigma^2))
points(a,s,cex = .5,col = "blue")
dev.off()

