delta1 <- function(a,v,f,m, Student = FALSE){ 
pu <- length(f$u)
du <- c(diff(f$u)[1],diff(f$u))
m <- rep(m, length(v))
if(Student){
A <- dt(outer(a,f$u,"-")/outer(sqrt(yv/m),rep(1,pu)),m-1)
B <- (A %*% (f$u * du * f$fu))/(A %*% (du * f$fu))
}
else { # utilize normal form of the likelihood
pv <- length(f$v)
dv <- c(diff(f$v)[1],diff(f$v))
Au <- dnorm(outer(outer(a, f$u, "-") * outer(sqrt(m),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(f$v)) # dim = n * pv * pu
B <- tensor(Au, (dv*f$fv),3,1)
g <- B %*% (f$fu * du)
B <- (B %*% (f$u * f$fu * du))/g
}
B
}

delta2 <- function(a,v,f,m, outer = FALSE){ #Bayes Rule using full likelihood
pu <- length(f$u)
pv <- length(f$v)
du <- c(diff(f$u)[1],diff(f$u))
dv <- c(diff(f$v)[1],diff(f$v))
m <- rep(m, length(v))
r <- (m-1)/2
R <- outer(r*v,f$v,"/")  
sgamma <- outer(v * gamma(r),rep(1,pv))
r <- outer(r, rep(1,pv))
Au <- dnorm(outer(outer(a, f$u, "-") * outer(sqrt(m),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(f$v)) # dim = n * pu * pv
Au <- aperm(Au,c(1,3,2)) # permute Au indices to align with those of Av
if(outer){
Av <- (exp(-R) * R^r)/sgamma
fvp <- Av * outer(rep(1,length(v)),(dv*f$fv))/
outer(tensor(Av,(dv *f$fv),2,1),rep(1,pv))
A <- outer(Av,rep(1,pu)) * Au
B <- tensor(Au,(f$u*du*f$fu),3,1) %*% t(fvp)
C <- tensor(Au,(du*f$fu),3,1) %*% t(fvp)
B <- B/C
}
else{
Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
A <- Av * Au #dim = n * pv * pu
B <- tensor (A, (dv*f$fv),2,1)
B <- tensor(B, (f$u * du * f$fu), 2,1)/tensor(B, (du *f$fu), 2,1)
}
B
}

delta3 <- function(a,v,f,m){ #Bayes Rule using full likelihood
n <- length(a)
pu <- length(f$u)
pv <- length(f$v)
du <- c(diff(f$u)[1],diff(f$u))
dv <- c(diff(f$v)[1],diff(f$v))
m <- rep(m, length(v))
r <- (m-1)/2
R <- outer(r*v,f$v,"/")  
sgamma <- outer(v * gamma(r),rep(1,pv))
r <- outer(r, rep(1,pv))
Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
Au <- dnorm(outer(outer(a, f$u, "-") * outer(sqrt(m),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(f$v)) # dim = n * pu * pv
Au <- aperm(Au,c(1,3,2)) # permute Au indices to align with those of Av
A <- matrix(Av * Au, n, pu * pv) * outer(rep(1,n),f$fuv)
A <- pmax(A,0)
buv  <- expand.grid(theta = rep(1,length(f$v)), alpha = f$u)
nuv  <- nrow(buv)
A <- A/apply(A, 1, sum)
A%*%buv[,2]
}

delta4 <- function(a,f,m){ #Bayes Rule using full likelihood but forget to compute variances
n <- length(a)
pu <- length(f$u)
pv <- length(f$v)
du <- c(diff(f$u)[1],diff(f$u))
dv <- c(diff(f$v)[1],diff(f$v))
m <- rep(m, length(a))
Au <- dnorm(outer(outer(a, f$u, "-") * outer(sqrt(m),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(f$v)) # dim = n * pu * pv
Au <- aperm(Au,c(1,3,2)) # permute Au indices to align with those of Av
A <- matrix(Au, n, pu * pv) * outer(rep(1,n),f$fuv)
A <- pmax(A,0)
buv  <- expand.grid(theta = rep(1,length(f$v)), alpha = f$u)
nuv  <- nrow(buv)
A <- A/apply(A, 1, sum)
A%*%buv[,2]
}


gahat <- function(a,v,f,m){ 
#This computes the marginal (mixture) density of a
pu <- length(f$u)
pv <- length(f$v)
du <- c(diff(f$u)[1],diff(f$u))
dv <- c(diff(f$v)[1],diff(f$v))
m <- rep(m, length(v))
Au <- dnorm(outer(outer(a, f$u, "-") * outer(sqrt(m),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(m),rep(1,pu)),sqrt(f$v)) # dim = n * pv * pu
B <- tensor(Au, (dv*f$fv),3,1)
ga <- B %*% (f$fu * du)
ga/sum(ga*diff(a)[1]) #normalization
}

