# Illustrate why it is a good idea to introduce variance heterogeneity
# For different rho's, I plot the sample density for the demeaned partial difference (y_it - rho y_i,t-1). 
# squant computes quantiles of individual specific variance
# Normal density with 25,50,75 quantile variance is imposed to compare with sample density on the partial difference. 

PQ <- function(h, id){
if(is.vector(h))
h <- matrix(h, ncol = 1)
Ph <- unique(id)
Ph <- cbind(Ph, table(id))
for(i in 1:ncol(h))
Ph <- cbind(Ph, tapply(h[, i], id, mean))
is <- tapply(id, id)
Ph <- Ph[is, - (1:2)]
Qh <- h - Ph
list(Ph=as.matrix(Ph), Qh=as.matrix(Qh), is=is)
}

require(lattice)
require(foreign)
source("MP_DataProcess2.R")  #pre-processing data to get earning residual
rhos = 2:10/10
pdf("QQ.pdf",height = 10, width = 7)

Y <- function(psid, rho) {
    d <- tapply(psid$ystand, psid$id, pardiff, rho = rho)
    y  <- unlist(d)
    id <- psid$id
    s <- !is.na(y)
    y <- y[s]
    id <- id[s]
    PQ(y,id)$Qh   #demean
}
# Make Q Matrix (Couldn't figure out how to do this with panel.qqmath, aargh)
A <- matrix(0, 500, length(rhos))
for(i in 1:length(rhos))
    A[,i] <- quantile(Y(psid, rhos[i]), 1:500/501)
B <- data.frame(cbind(y = c(A), rho = rep(rhos, each = 500)))
s <- sqrt(tapply(B[,1],B[,2],"var"))
B[,1] <- B[,1]/rep(s,each = 500)
B[,2] <- as.factor(B[,2])

tp1 <- qqmath( ~ y | rho, data = B,  pch = "+", distribution = qnorm, 
	      xlab = "Gaussian Quantiles", ylab = "Empirical Quantiles",
	      par.strip.text = list(cex = .6), strip = strip.custom(style = 4), grid = TRUE, abline = c(0,1))
plot(tp1)
dev.off()
