# Illustrate why it is a good idea to introduce variance heterogeneity
# For different rho's, plot the scatter of alphahat and log thetahats

PQ <- function(h, id){
    if(is.vector(h))
    h <- matrix(h, ncol = 1)
    Ph <- unique(id)
    Ph <- cbind(Ph, table(id))
    for(i in 1:ncol(h))
    Ph <- cbind(Ph, tapply(h[, i], id, mean))
    is <- tapply(id, id)
    Ph <- Ph[is, - (1:2)]
    Qh <- h - Ph
    list(Ph=as.matrix(Ph), Qh=as.matrix(Qh), is=is)
}

require(lattice)
require(foreign)
source("MP_DataProcess2.R")  #pre-processing data to get earning residual
rhos = c(0.4, 0.6, 0.8,1)
pdf("MV.pdf",height = 7, width = 7)

Yid <- function(psid, rho, fun = "mean") {
    d <- tapply(psid$ystand, psid$id, pardiff, rho = rho)
    y  <- unlist(d)
    id <- psid$id
    s <- !is.na(y)
    y <- y[s]
    id <- id[s]
    tapply(y,id, fun)
}
# Make MV Matrix (Couldn't figure out how to do this with panel.qqmath, aargh)
M <- Yid(psid, rho = .5)
n <- nrow(M) 
M <- matrix(0, n, length(rhos))
V <- matrix(0, n, length(rhos))
for(i in 1:length(rhos)){
    M[,i] <- Yid(psid, rhos[i], fun = "mean")
    V[,i] <- Yid(psid, rhos[i], fun = "var")
}
B <- data.frame(cbind(x = c(M), y = c(V), rho = rep(rhos, each = n)))
B[,3] <- as.factor(B[,3])

tp1 <- xyplot(log(y) ~ x | rho, data = B,  cex = .2, 
	      xlab = expression(bar(y)), ylab = "log S",
	      par.strip.text = list(cex = .6), strip = strip.custom(style = 4))
plot(tp1)
dev.off()
