S <- function(y, x1, x2, w, id, beta){
	# construct sample variance to be passed onto GVmix
	m <- tapply(y, id, "length")
	wsum <- tapply(w, id, "sum")
	ybar <- tapply(y * w, id, "sum")/wsum
	x1bar <- tapply(x1 * w, id, "sum")/wsum
	x2bar <- tapply(x2 * w, id, "sum")/wsum
	(tapply(w * (y-x1*beta[1]-x2*beta[2])^2, id, "sum") - wsum * (ybar - x1bar *beta[1]-x2bar*beta[2])^2)/(m-1)
}

P <- function(y, w, id){
    # Individual mean
    wsum <- tapply(w,id,"sum")
    tapply(w*y,id,"sum")/wsum
}



# Break out the Gamma mixture part from TLVmix
Gammamix <- function(s, m, v, pv = 300, eps = 1e-06, rtol = 1e-06, verb = 0) 
{
    r <- (m - 1)/2
    n <- length(s)
    if (missing(v)) 
    v <- seq(min(s) - eps, max(s) + eps, length = pv)
    pv <- length(v)
    dv <- diff(v)
    dv <- c(dv[1], dv)
    wv <- rep(1, n)/n
    R <- outer(r * s, v, "/")
    vgamma <- outer(gamma(r)/r, v)
    r <- outer((m - 1)/2, rep(1, pv))
    A <- (exp(-R) * R^(r - 1))/vgamma
    A <- Matrix(A, sparse = TRUE)
    f <- KWDual(s, wv, dv, A, rtol = rtol, verb = verb)
    y <- f$f/sum(f$f * dv)
    g <- A %*% y * dv[1]
    z <- list(x = v, y = y, g = g, logLik = n * f$logLik, flag = f$status)
    class(z) <- "density"
    return(z)
}

# compute likelihood for WTLVmix

LikWTLVmix<-function(mixing,y,id,w){
	#The marginal Tweedie formula for location parameter in the location-scale mixture model
	#mixing is the KW output
	#y is the transformed-to-normal hitting average
	#id is the player's id
	#w is the weights, specified as 4*AB
    #output: $u: Tweedie for location parameter marginalize out scale
    #        $v: Tweedie for scale parameter marginalize out location
    #        $g: likelihood \int int f(y|u,v)f(u)f(v)dudv
    
    wsum <- tapply(w,id,"sum")
    t <- tapply(w*y,id,"sum")/wsum
    m <- tapply(y,id,"length")
    r <- (m-1)/2
    s <- (tapply(w*y^2,id,"sum") - t^2*wsum)/(m-1)
    n <- length(s)
    
    u<-mixing$u
    v<-mixing$v
    pu=length(u)
    pv=length(v)
    du <- diff(u)
    du <- c(du[1],du)
    wu <- rep(1,n)/n
    dv <- diff(v)
    dv <- c(dv[1],dv)
    wv <- rep(1,n)/n
    
    R <- outer(r*s,v,"/")  
    sgamma <- outer(s * gamma(r),rep(1,pv))
    r <- outer((m - 1)/2, rep(1,pv))
    Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
    Au <- dnorm(outer(outer(t, u, "-") * outer(sqrt(wsum),rep(1,pu)), sqrt(v), "/"))
    Au <- Au/outer(outer(1/sqrt(wsum),rep(1,pu)),sqrt(v))
    Au <- aperm(Au,c(1,3,2)) # permute Au indices so that they are aligned with those of Av
    A <- Av * Au #dim: n*pv*pu
    
    fu<-mixing$fu
    fv<-mixing$fv
    au<-matrix(0,n,pu)
    for (i in 1:pu){
        au[,i]<-A[,,i]%*%(dv*fv)
	}
    g <- au%*%(du*fu)
    # an extra factor
    r <- (m-1)/2
    logK <- log(gamma(r)) - r*log(r) - 0.5 * log(wsum) - r*log(2*pi) - log(s^(r-1)) + 0.5 * tapply(log(w), id, "sum")
    sum(logK)+ sum(log(g))
}


WTLmix <- function(x, s, w, id, m, u, pu = 300, eps = 1e-06, rtol = 1e-06, verb = 0) 
{
    wsum <- tapply(w, id, "sum")
    n <- length(x)
    if (missing(u)) 
    u <- seq(min(x) - eps, max(x) + eps, length = pu)
    du <- diff(u)
    du <- c(du[1], du)
    w <- rep(1, n)/n
    Au <- dt(outer(x , u, "-") * outer(sqrt(wsum/s), rep(1, pu)), 
    df = m - 1)
    Au <- Au/outer(sqrt(s/wsum), rep(1, pu))
    Au <- Matrix(Au, sparse = TRUE)
    f <- KWDual(t, w, du, Au, rtol = rtol, verb = verb)
    fu <- f$f/(sum(f$f*du))
    flag <- f$status
    g <- Au %*% fu * du[1]
    list(u = u, fu = fu, g = g, logLik = n * f$logLik, flag = flag)
}


# compute likelihood for WGLVmixbi (Bivariate mixing for Gaussian panel data)

LikGLVmixbi<-function(mixing,y,id,w){
	#The marginal Tweedie formula for location parameter in the location-scale mixture model
	#mixing is the KW output
	#y is the transformed-to-normal hitting average
	#id is the player's id
	#w is the weights, specified as 4*AB
    #output: $u: Tweedie for location parameter marginalize out scale
    #        $v: Tweedie for scale parameter marginalize out location
    #        $g: likelihood \int int f(y|u,v)f(u)f(v)dudv
    
    wsum <- tapply(w,id,"sum")
    t <- tapply(w*y,id,"sum")/wsum
    m <- tapply(y,id,"length")
    r <- (m-1)/2
    s <- (tapply(w*y^2,id,"sum") - t^2*wsum)/(m-1)
    n <- length(s)
    
    u<-mixing$u
    v<-mixing$v
    pu=length(u)
    pv=length(v)
    du <- diff(u)
    du <- c(du[1],du)
    wu <- rep(1,n)/n
    dv <- diff(v)
    dv <- c(dv[1],dv)
    wv <- rep(1,n)/n
    
    R <- outer(r*s,v,"/")  
    sgamma <- outer(s * gamma(r),rep(1,pv))
    r <- outer((m - 1)/2, rep(1,pv))
    Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
    Au <- dnorm(outer(outer(t, u, "-") * outer(sqrt(wsum),rep(1,pu)), sqrt(v), "/"))
    Au <- Au/outer(outer(1/sqrt(wsum),rep(1,pu)),sqrt(v))
    Au <- aperm(Au,c(1,3,2)) # permute Au indices so that they are aligned with those of Av
    A <- Av * Au #dim: n*pv*pu
    
    B <- NULL
    for (j in 1:pu){
    B <- cbind(B,A[,,j])
    }
    
    duv = kronecker(du,dv)
    g = B %*% (mixing$fuv * duv)
    # an extra factor
    r <- (m-1)/2
    logK <- log(gamma(r)) - r*log(r) - 0.5 * log(wsum) - r*log(2*pi) - log(s^(r-1)) + 0.5 * tapply(log(w), id, "sum")
    sum(logK)+ sum(log(g))
}

