
egbar <- function(x, a){ # Oracle Estimator
    a <- sort(a)
    n <- length(x)
    sapply(1:n, function(i) sum(a * dnorm(x[i] - a))/sum(dnorm(x[i] - a)))
}
BDE <- function(y, T = 300, df = 5, c0 = 0.1){
    # Bayesian Deconvolution Estimator: Efron (B'ka, 2016)
    require(splines)
    eps <- 1e-04
    if(length(T) == 1) T <- seq(min(y)-eps, max(y)+eps, length = T)
    X <- ns(T, df = df)
    a0 <- rep(0, ncol(X))
    A <- dnorm(outer(y,T,"-"))
    qmle <- function(a, X, A, c0){
	g <- exp(X %*% a)
	g <- g/sum(g)
	f <- A %*% g
	-sum(log(f)) + c0 * sum(a^2)^.5
    }
    ahat <- nlm(qmle, a0, X=X, A=A, c0 = c0)$estimate
    g <- exp(X %*% ahat)
    #g <- g/integrate(approxfun(T,g),min(T),max(T))$value
    g <- g/sum(g * diff(T)[1])
    z <- list(x = T,y = g)
    class(z) <- "BDE"
    z
}
predict.BDE <- function(f, xx){
    n <- length(xx)
    x <- f$x
    y <- f$y
    sapply(1:n, function(i) sum(x * dnorm(xx[i] - x) * y)/sum(dnorm(xx[i] - x) * y))
}

require(REBayes)
set.seed(25)
N <- 500
R <- matrix(0,N,6)
for(i in 1:N){
    a <- c(runif(500, -1.7, -0.7), runif(1000, 0.7, 2.7))
    x <- a + rnorm(1500)
    R[i,1] <- mean((a - egbar(x,a))^2)
    R[i,2] <- mean((a - predict(BDE(x), x))^2)
    R[i,3] <- mean((a - predict(BDE(x, df = 20), x))^2)
    R[i,4] <- mean((a - predict(BDE(x, c0 = 1), x))^2)
    R[i,5] <- mean((a - predict(BDE(x, df = 20, c0 = 1), x))^2)
    R[i,6] <- mean((a - predict(GLmix(x), newdata = x))^2)
}

