# Shakespeare figure for the Efron comment

require(deconvolveR)
require(REBayes)
load("DP7.Rda") #results for DP fitting

data(bardWordCount)
w <- bardWordCount
x <- 1:100
x <- rep(1:100, times = w)

# KW Fit
v <- exp(seq(-8, 5, 0.005)) 
z <- Pmix(x, v = v, support = c(0,100), rtol = 1e-14)
fKW <- w[1] * z$g[-1]/z$g[1]

# Efron Fit
v <- exp(seq(-4, 4.6, by = 0.02))
r <- deconv(v, y = bardWordCount, n = 100, c0 = 2)
g <- r$stats[,"g"]
g <- g/sum(g)
fE <- r$P %*% g
fE <- w[1] * fE[-1]/fE[1]

# DP Fit
tdpois <- function(x, t)
    dpois(x, t)/(ppois(100, t) - ppois(0, t))
Z <- lambdaPosteriorFrame(dp, v)
gDP <- c(Z$Y[1,2], diff(Z$Y[,2]))
A <- outer(1:100, Z$x, "tdpois")
fDP <- A %*% gDP
fDP <- w[1] * fDP[-1]/fDP[1]

# Fisher Fit
logL <- function(para, w){
    li <- rep(0, (length(w)-1))
    for (j in 1:(length(w)-1))
	li[j] = log(dpois(w[j+1], w[1]*gamma(para[1]+(j+1))*(para[2])^(j)/(factorial(j+1)*gamma(para[1]+1))))
    -sum(li)
}
par <- optim(c(-0.3, 0.85), logL, w = w, 
		 lower = c(-0.5, 0.8), upper = c(-0.05, 0.9999), method = "L-BFGS-B")$par
etahat <- rep(0, length(w))
etahat[1] <- w[1]
for (j in 1:length(etahat)-1)
    etahat[j+1] <- w[1]*gamma(par[1]+(j+1))*(par[2])^(j)/(factorial(j+1)*gamma(par[1]+1))

pdf("Shakespeare.pdf", width = 10, height = 5)
par(mfrow = c(1,2))

plot(Z, ylim = c(1/4, 1), xlab = expression(lambda), ylab = expression(G[n] (lambda)))
G0 <- cumsum(z$y)
lines(z$x, G0/G0[length(G0)], lwd = 2, col = 1)
G1 <- cumsum(g)
lines(v, G1/G1[length(G1)], lwd = 2, lty = 2, col = 2)
legend("bottomright", c("KW", "Efron", "DP"), col = c(1, 2, "lightblue"), lwd = c(2,2,5), lty = c(1,2,1))

plot(log(w[-1]), cex = .5, xlab = "occurence frequency", ylab = "log(counts)")
lines(log(fKW),col= 1, lty = 1, lwd = 2)
lines(log(fE), col = 2, lty = 2, lwd = 2)
lines(log(fDP), col = 3, lty = 3, lwd = 2)
lines(log(etahat[-1]), col = 4, lty = 4, lwd = 2)
legend("bottomleft", c("KW", "Efron", "DP", "Fisher"), col = 1:4, lwd = 2, lty = 1:4)

dev.off()

# compute posterior medians for alpha and Gamma rate parameter
K <- 1:floor(0.5 * length(dp$weightsChain))
ratebar <- median(matrix(unlist(dp$priorParametersChain),2)[2,-K])
alphabar <- median(dp$alphaChain[-K])





