% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronogram.R
\name{voronogram}
\alias{voronogram}
\title{Estimate a voronogram density or regression function}
\usage{
voronogram(x, y, z, wgts = rep(1, length(x)), lambda = 1, tau = 0.5)
}
\arguments{
\item{x}{observations on \code{x}}

\item{y}{observations on \code{y}}

\item{z}{observations on \code{z}}

\item{wgts}{weights}

\item{lambda}{regularization parameter}

\item{tau}{quantile parameter}
}
\value{
list of class voronogram with components: 
\item{x}{observations on \code{x} as used in the fitting}
	\item{y}{observations on \code{y} as used in the fitting}
	\item{z}{observations on \code{z} as used in the fitting} 
\item{fit}{fitted function values }
}
\description{
Voronograms are piecewise constant functions defined on a Voronoi
tesselation of the plane.  Estimation of voronograms is done by minimizing
an l1 measure of fidelity regularized by a penalty defined by the total
variation of the estimated density.
}
\details{
The function estimates either a piecewise constant  quantile regression function if the argument
\code{z} is provided, or a density function if \code{z} is missing.  In the
latter case, the argument \code{tau} is formally valid, but may be hard to
interpret.  For density estimation the function minimizes an l1 measure of
fidelity subject to a constraint on the total variation of fitted density.
The reference distribution for the fidelity criterion is given by the
voronogram that put mass 1/n in each of the Voronoi cells. By default
weights are chosen in the density estimation setting so that the fidelity
can be interpreted as a functional version of the l1 distance between the
fitted and reference density.  The example below illustrates the density
functionality, for the regression version try:  \code{demo(tseg)}.
}
\note{
This function draws heavily on the tripack package for various
	functionality for producing and manipulating Voronoi tesselations.
}
\examples{
x <- rnorm(500)
y <- rnorm(500)
vm <- tripack::voronoi.mosaic(x,y)
g <- vareas(x,y,vm)
v <- voronogram(x,y,lambda=.5)
plot(v)

}
\seealso{
\code{\link{plot.voronogram}}
}
\author{
Roger Koenker
}
\keyword{smooth}
