#title("noisey segmented image")
par(mfrow=c(2,2))
n <- 100
x <- (1:n) - floor(n/2)
y <- (1:n) - floor(n/2)
Timage <- function(x,y){
    .5 + .25*((x>0) & (y < .5*x)) - .25*((x<0) & (y < .5*abs(x)))
}
z <- outer(x,y,"Timage") + matrix(rnorm(n^2)/10,n,n)
palette(topo.colors(100))
	N <- 500
	xi <- sample(1:n,N,replace=TRUE)
	yj <- sample(1:n,N,replace=TRUE)
	A <- as.data.frame(cbind(xi,yj))
        dupA <- duplicated(A)
	if(any(dupA)){
		xx <- xi[!dupA]
		yy <- yj[!dupA]
		zz <- z[cbind(xx,yy)]
		}
	n <- length(xx)
	xx <- xx + rnorm(n)/100
	yy <- yy + rnorm(n)/100
	#Fitting the Voronograms
	lambdas <- c(.01,.1,.2,.5)
	for(i in 1:4){
		zhat <- voronogram(xx,yy,zz,lambda=lambdas[i])
		plot(zhat)
		title(paste("Voronogram:  lam =",lambdas[i]))
		}
