#' Find Voronoi Vertices
#'
#' This is a copy of a hidden function in tripack called  
#' voronoi.findvertices
#'
#' @param site identifier
#' @param vor voronoi object 
#'
#' @return ordered vertices
#' @export
vfind <- function (site, vor) 
{
    p <- cbind(vor$p1, vor$p2, vor$p3)
    a <- which(p == site, arr.ind = TRUE)
    vertices <- a[, 1]
    triples <- p[a[, 1], ]
    triples
    triples <- t(triples)
    pairs <- triples[which(triples != site)]
    m <- matrix(pairs, ncol = 2, byrow = TRUE)
    orderedvs <- integer(30)
    vnum <- 1
    orderedvs[vnum] <- vertices[1]
    vnum <- 1 + vnum
    firstv <- m[1, 1]
    nextv <- m[1, 2]
    m[1, ] <- -1
    looking <- TRUE
    while (looking) {
        t <- which(m == nextv, arr.ind = TRUE)
        if (length(t) == 0) {
            vnum <- 1
            looking <- FALSE
        }
        else {
            t.row <- t[1, 1]
            t.col <- t[1, 2]
            orderedvs[vnum] <- vertices[t.row]
            vnum <- 1 + vnum
            othercol <- (3 - t.col)
            nextv <- m[t.row, othercol]
            m[t.row, ] <- -1
            if (nextv == firstv) 
                looking <- FALSE
        }
    }
    orderedvs[1:vnum - 1]
}
